/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataActionResolver;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsDataImportException;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWebCmsPropertyDataImporter<T, U extends SettableIdBasedEntity<U>>
implements WebCmsPropertyDataImporter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebCmsPropertyDataImporter.class);
    private WebCmsDataConversionService conversionService;

    @Override
    public boolean importData(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry data, T parent, WebCmsDataAction action) {
        try {
            LOG.trace("Importing data entry {}", (Object)data);
            U existing = this.getExisting(data, parent);
            action = WebCmsDataActionResolver.resolveAction(existing, data);
            LOG.trace("Resolved import action {} to {}, existing item: {}", new Object[]{data.getImportAction(), action, existing != null});
            if (action != null) {
                if (action == WebCmsDataAction.DELETE) {
                    this.delete(existing, parent);
                } else {
                    U dto = this.createDto(data, existing, action, parent);
                    if (dto != null) {
                        boolean dataValuesApplied;
                        boolean bl = dataValuesApplied = data.isSingleValue() ? this.applySingleValue(data.getSingleValue(), dto) : this.applyDataValues(data.getMapData(), dto);
                        if (existing == null || dataValuesApplied) {
                            this.save(dto, parent);
                        } else {
                            LOG.trace("Skipping saving DTO as no actual values have been updated");
                        }
                    }
                }
            } else {
                LOG.trace("Skipping data entry as no valid action was resolved");
            }
        }
        catch (WebCmsDataImportException die) {
            throw die;
        }
        catch (Exception e) {
            throw new WebCmsDataImportException(data, (Throwable)e);
        }
        return true;
    }

    protected abstract U createDto(WebCmsDataEntry var1, U var2, WebCmsDataAction var3, T var4);

    protected abstract void save(U var1, T var2);

    protected abstract void delete(U var1, T var2);

    protected abstract U getExisting(WebCmsDataEntry var1, T var2);

    protected boolean applyDataValues(Map<String, Object> values, U dto) {
        return this.conversionService.convertToPropertyValues(values, dto);
    }

    private boolean applySingleValue(Object value, U dto) {
        return this.conversionService.convertSingleValue(value, dto);
    }

    @Autowired
    void setConversionService(WebCmsDataConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

