/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.core.convert.StringToDateTimeConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.stereotype.Service;

@Service(value="webCmsDataConversionService")
public class WebCmsDataConversionService
extends DefaultConversionService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDataConversionService.class);
    private final Map<Class, String> singleValueProperties = new HashMap<Class, String>();

    public WebCmsDataConversionService() {
        this.addConverter((GenericConverter)new StringToDateTimeConverter((ConversionService)this));
    }

    public void registerSingleValueProperty(Class owner, String propertyName) {
        this.singleValueProperties.put(owner, propertyName);
    }

    public boolean convertToPropertyValues(Map<String, Object> data, Object dto) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(dto);
        AtomicBoolean modified = new AtomicBoolean(false);
        data.forEach((propertyName, propertyValue) -> {
            if (propertyName.contains(":") || propertyName.startsWith("#")) {
                LOG.trace("Skipping property {} - assuming separate importer wil be used", propertyName);
            } else {
                TypeDescriptor typeDescriptor = beanWrapper.getPropertyTypeDescriptor(propertyName);
                if (typeDescriptor == null) {
                    LOG.warn("Skipping unknown property: {}", propertyName);
                } else {
                    TypeDescriptor sourceType = TypeDescriptor.forObject((Object)propertyValue);
                    if (propertyValue instanceof Map && !this.canConvert(sourceType, typeDescriptor)) {
                        Object target = beanWrapper.getPropertyValue(propertyName);
                        if (target == null) {
                            LOG.error("Unable to convert property {} - target is null", propertyName);
                            throw new RuntimeException("Unable to converted nested object - value is null for property " + propertyName);
                        }
                        if (this.convertToPropertyValues((Map)propertyValue, target)) {
                            modified.set(true);
                        }
                    } else {
                        Object valueToSet = this.convert(propertyValue, sourceType, typeDescriptor);
                        if (propertyValue != null && valueToSet == null) {
                            throw new IllegalArgumentException("Illegal converted value for '" + propertyName + "': " + sourceType.getName() + " to " + typeDescriptor.getName() + " resulted in null for '" + propertyValue + "'");
                        }
                        Object currentValue = beanWrapper.getPropertyValue(propertyName);
                        if (!Objects.equals(currentValue, valueToSet)) {
                            modified.set(true);
                            beanWrapper.setPropertyValue(propertyName, valueToSet);
                        }
                    }
                }
            }
        });
        return modified.get();
    }

    public boolean convertSingleValue(Object value, Object dto) {
        String propertyName = this.singleValueProperties.get(dto.getClass());
        if (propertyName == null) {
            throw new IllegalArgumentException("Unable to convert value '" + value + "' as single value for " + dto.getClass().getName());
        }
        return this.convertToPropertyValues(Collections.singletonMap(propertyName, value), dto);
    }
}

