/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.modules.webcms.data.WebCmsDataImportAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class WebCmsDataEntry {
    public static final String ROOT = "<root>";
    private final String key;
    private final Map<String, Object> mapData;
    private final Collection<Object> collectionData;
    private final Object singleValue;
    private final WebCmsDataEntry parent;
    private String identifier;
    @NonNull
    private WebCmsDataImportAction importAction = WebCmsDataImportAction.CREATE_OR_UPDATE;
    private List<Consumer<WebCmsDataEntry>> completedCallbacks;
    private WebCmsDataEntryType dataType;

    private WebCmsDataEntry(String identifier, String key, WebCmsDataEntry parent, Object data, WebCmsDataImportAction importAction) {
        this.identifier = identifier;
        this.completedCallbacks = new ArrayList<Consumer<WebCmsDataEntry>>();
        this.key = key;
        this.parent = parent;
        if (parent != null) {
            this.importAction = parent.importAction;
            this.identifier = parent.identifier;
        }
        if (importAction != null) {
            this.importAction = importAction;
        }
        if (data instanceof Map) {
            this.dataType = WebCmsDataEntryType.MAP_DATA;
            LinkedHashMap map = new LinkedHashMap((Map)data);
            this.importAction = Optional.ofNullable(WebCmsDataImportAction.fromAttributeValue((String)map.remove("wcm:action"))).orElse(this.importAction);
            this.mapData = Collections.unmodifiableMap(map);
            this.collectionData = Collections.emptyList();
            this.singleValue = null;
        } else if (data instanceof Collection) {
            this.dataType = WebCmsDataEntryType.COLLECTION_DATA;
            this.collectionData = (Collection)data;
            this.mapData = Collections.emptyMap();
            this.singleValue = null;
        } else {
            this.dataType = WebCmsDataEntryType.SINGLE_VALUE;
            this.singleValue = data;
            this.mapData = Collections.emptyMap();
            this.collectionData = Collections.emptyList();
        }
    }

    public boolean isMapData() {
        return WebCmsDataEntryType.MAP_DATA.equals((Object)this.dataType);
    }

    public boolean isCollectionData() {
        return WebCmsDataEntryType.COLLECTION_DATA.equals((Object)this.dataType);
    }

    public <V, U extends V> U getSingleValue(Class<V> expectedType) {
        return (U)expectedType.cast(this.getSingleValue());
    }

    public boolean isSingleValue() {
        return WebCmsDataEntryType.SINGLE_VALUE.equals((Object)this.dataType);
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public String getParentKey() {
        return this.hasParent() ? this.parent.getKey() : null;
    }

    public String getLocation() {
        String parent;
        String current = "/" + (StringUtils.isEmpty((CharSequence)this.key) ? (this.isMapData() ? "<map>" : (this.isCollectionData() ? "<list>" : "")) : (ROOT.equals(this.key) ? "" : this.key));
        if (this.hasParent() && !"/".equals(parent = this.getParent().getLocation())) {
            return parent + current;
        }
        return current;
    }

    public String toString() {
        Map<String, Object> data = this.isMapData() ? this.mapData : (this.isCollectionData() ? this.collectionData : this.singleValue);
        return "WebCmsDataEntry(identifier='" + this.identifier + "',location='" + this.getLocation() + "',data=" + data + ")";
    }

    public void addCompletedCallback(Consumer consumer) {
        this.completedCallbacks.add(consumer);
    }

    public static WebCmsDataEntryBuilder builder() {
        return new WebCmsDataEntryBuilder();
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Object> getMapData() {
        return this.mapData;
    }

    public Collection<Object> getCollectionData() {
        return this.collectionData;
    }

    public Object getSingleValue() {
        return this.singleValue;
    }

    public WebCmsDataEntry getParent() {
        return this.parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @NonNull
    public WebCmsDataImportAction getImportAction() {
        return this.importAction;
    }

    public List<Consumer<WebCmsDataEntry>> getCompletedCallbacks() {
        return this.completedCallbacks;
    }

    public WebCmsDataEntryType getDataType() {
        return this.dataType;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setImportAction(@NonNull WebCmsDataImportAction importAction) {
        if (importAction == null) {
            throw new NullPointerException("importAction is marked non-null but is null");
        }
        this.importAction = importAction;
    }

    public void setCompletedCallbacks(List<Consumer<WebCmsDataEntry>> completedCallbacks) {
        this.completedCallbacks = completedCallbacks;
    }

    public void setDataType(WebCmsDataEntryType dataType) {
        this.dataType = dataType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebCmsDataEntry)) {
            return false;
        }
        WebCmsDataEntry other = (WebCmsDataEntry)o;
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Map<String, Object> this$mapData = this.getMapData();
        Map<String, Object> other$mapData = other.getMapData();
        if (this$mapData == null ? other$mapData != null : !((Object)this$mapData).equals(other$mapData)) {
            return false;
        }
        Collection<Object> this$collectionData = this.getCollectionData();
        Collection<Object> other$collectionData = other.getCollectionData();
        if (this$collectionData == null ? other$collectionData != null : !((Object)this$collectionData).equals(other$collectionData)) {
            return false;
        }
        Object this$singleValue = this.getSingleValue();
        Object other$singleValue = other.getSingleValue();
        if (this$singleValue == null ? other$singleValue != null : !this$singleValue.equals(other$singleValue)) {
            return false;
        }
        WebCmsDataEntry this$parent = this.getParent();
        WebCmsDataEntry other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        WebCmsDataImportAction this$importAction = this.getImportAction();
        WebCmsDataImportAction other$importAction = other.getImportAction();
        if (this$importAction == null ? other$importAction != null : !((Object)((Object)this$importAction)).equals((Object)other$importAction)) {
            return false;
        }
        List<Consumer<WebCmsDataEntry>> this$completedCallbacks = this.getCompletedCallbacks();
        List<Consumer<WebCmsDataEntry>> other$completedCallbacks = other.getCompletedCallbacks();
        if (this$completedCallbacks == null ? other$completedCallbacks != null : !((Object)this$completedCallbacks).equals(other$completedCallbacks)) {
            return false;
        }
        WebCmsDataEntryType this$dataType = this.getDataType();
        WebCmsDataEntryType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !((Object)((Object)this$dataType)).equals((Object)other$dataType));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Map<String, Object> $mapData = this.getMapData();
        result = result * 59 + ($mapData == null ? 43 : ((Object)$mapData).hashCode());
        Collection<Object> $collectionData = this.getCollectionData();
        result = result * 59 + ($collectionData == null ? 43 : ((Object)$collectionData).hashCode());
        Object $singleValue = this.getSingleValue();
        result = result * 59 + ($singleValue == null ? 43 : $singleValue.hashCode());
        WebCmsDataEntry $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        WebCmsDataImportAction $importAction = this.getImportAction();
        result = result * 59 + ($importAction == null ? 43 : ((Object)((Object)$importAction)).hashCode());
        List<Consumer<WebCmsDataEntry>> $completedCallbacks = this.getCompletedCallbacks();
        result = result * 59 + ($completedCallbacks == null ? 43 : ((Object)$completedCallbacks).hashCode());
        WebCmsDataEntryType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : ((Object)((Object)$dataType)).hashCode());
        return result;
    }

    public static class WebCmsDataEntryBuilder {
        private String identifier;
        private String key;
        private WebCmsDataEntry parent;
        private Object data;
        private WebCmsDataImportAction importAction;

        WebCmsDataEntryBuilder() {
        }

        public WebCmsDataEntryBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public WebCmsDataEntryBuilder key(String key) {
            this.key = key;
            return this;
        }

        public WebCmsDataEntryBuilder parent(WebCmsDataEntry parent) {
            this.parent = parent;
            return this;
        }

        public WebCmsDataEntryBuilder data(Object data) {
            this.data = data;
            return this;
        }

        public WebCmsDataEntryBuilder importAction(WebCmsDataImportAction importAction) {
            this.importAction = importAction;
            return this;
        }

        public WebCmsDataEntry build() {
            return new WebCmsDataEntry(this.identifier, this.key, this.parent, this.data, this.importAction);
        }

        public String toString() {
            return "WebCmsDataEntry.WebCmsDataEntryBuilder(identifier=" + this.identifier + ", key=" + this.key + ", parent=" + this.parent + ", data=" + this.data + ", importAction=" + (Object)((Object)this.importAction) + ")";
        }
    }

    private static enum WebCmsDataEntryType {
        SINGLE_VALUE,
        MAP_DATA,
        COLLECTION_DATA;

    }
}

