/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsDataImportException;
import com.foreach.across.modules.webcms.data.WebCmsDataImportService;
import com.foreach.across.modules.webcms.data.WebCmsDataImporter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public final class WebCmsDataImportServiceImpl
implements WebCmsDataImportService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDataImportServiceImpl.class);
    private Collection<WebCmsDataImporter> importers = Collections.emptyList();

    @Override
    @Transactional
    public void importData(Map<String, Object> data) {
        this.importData(data, "generated:" + UUID.randomUUID().toString());
    }

    @Override
    @Transactional
    public void importData(Map<String, Object> data, String identifier) {
        this.importData(WebCmsDataEntry.builder().identifier(identifier).key("<root>").data(data).build());
    }

    @Override
    @Transactional
    public void importData(WebCmsDataEntry data) {
        try {
            this.importers.stream().filter(i -> i.supports(data)).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to import data for key: " + data.getKey())).importData(data);
        }
        catch (WebCmsDataImportException die) {
            throw die;
        }
        catch (Exception e) {
            throw new WebCmsDataImportException(data, (Throwable)e);
        }
        finally {
            data.getCompletedCallbacks().forEach(callback -> callback.accept(data));
        }
    }

    @Autowired
    void setImporters(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsDataImporter> importers) {
        this.importers = importers;
    }
}

