/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsDataImporter;
import com.foreach.across.modules.webcms.domain.domain.CloseableWebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.StringToWebCmsDomainConverter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class WebCmsDomainContextImporter
implements WebCmsDataImporter {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDomainContextImporter.class);
    private final StringToWebCmsDomainConverter domainConverter;
    private final WebCmsMultiDomainService multiDomainService;

    @Override
    public boolean supports(WebCmsDataEntry data) {
        return "wcm:domain".equals(data.getKey());
    }

    @Override
    public void importData(WebCmsDataEntry data) {
        CloseableWebCmsDomainContext ctx = this.multiDomainService.attachDomainContext(this.domainConverter.convert((String)data.getSingleValue()));
        if (data.hasParent()) {
            data.getParent().addCompletedCallback(dataEntry -> ctx.close());
        } else {
            data.addCompletedCallback(dataEntry -> ctx.close());
        }
    }

    public WebCmsDomainContextImporter(StringToWebCmsDomainConverter domainConverter, WebCmsMultiDomainService multiDomainService) {
        this.domainConverter = domainConverter;
        this.multiDomainService = multiDomainService;
    }
}

