/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.domain.CloseableWebCmsDomainContext;
import com.foreach.across.modules.webcms.domain.domain.StringToWebCmsDomainConverter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class WebCmsDomainContextPropertyImporter
implements WebCmsPropertyDataImporter {
    private final StringToWebCmsDomainConverter domainConverter;
    private final WebCmsMultiDomainService multiDomainService;
    public static final String DOMAIN = "wcm:domain";

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.BEFORE_ASSET_SAVED.equals((Object)phase) && DOMAIN.equals(dataEntry.getKey()) && asset instanceof WebCmsDomainBound;
    }

    public boolean importData(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry propertyData, Object asset, WebCmsDataAction action) {
        String domainKey = (String)propertyData.getSingleValue();
        WebCmsDomain domain = domainKey != null ? Optional.ofNullable(this.domainConverter.convert(domainKey)).orElseThrow(() -> new IllegalArgumentException("No domain with key '" + domainKey + "' was found")) : WebCmsDomain.NONE;
        CloseableWebCmsDomainContext ctx = this.multiDomainService.attachDomainContext(domain);
        if (propertyData.hasParent()) {
            propertyData.getParent().addCompletedCallback(dataEntry -> ctx.close());
        } else {
            propertyData.addCompletedCallback(dataEntry -> ctx.close());
        }
        return true;
    }

    public WebCmsDomainContextPropertyImporter(StringToWebCmsDomainConverter domainConverter, WebCmsMultiDomainService multiDomainService) {
        this.domainConverter = domainConverter;
        this.multiDomainService = multiDomainService;
    }
}

