/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class WebCmsPropertyDataImportService {
    private Collection<WebCmsPropertyDataImporter> propertyDataImporters = Collections.emptyList();

    public boolean executeBeforeAssetSaved(WebCmsDataEntry assetData, Map<String, Object> propertiesData, Object asset, WebCmsDataAction action) {
        return this.execute(WebCmsPropertyDataImporter.Phase.BEFORE_ASSET_SAVED, assetData, propertiesData, asset, action);
    }

    public boolean executeAfterAssetSaved(WebCmsDataEntry assetData, Map<String, Object> propertiesData, Object asset, WebCmsDataAction action) {
        return this.execute(WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED, assetData, propertiesData, asset, action);
    }

    private boolean execute(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry assetData, Map<String, Object> propertiesData, Object asset, WebCmsDataAction action) {
        return propertiesData.keySet().stream().map(propertyName -> WebCmsDataEntry.builder().key((String)propertyName).parent(assetData).data(propertiesData.get(propertyName)).build()).map(dataEntry -> this.importPropertyData(phase, (WebCmsDataEntry)dataEntry, asset, action)).collect(Collectors.toSet()).contains(Boolean.TRUE);
    }

    public boolean importPropertyData(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return this.propertyDataImporters.stream().filter(importer -> importer.supports(phase, dataEntry, asset, action)).findFirst().map(importer -> importer.importData(phase, dataEntry, asset, action)).orElse(Boolean.FALSE);
    }

    @Autowired
    void setPropertyDataImporters(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsPropertyDataImporter> propertyDataImporters) {
        this.propertyDataImporters = propertyDataImporters;
    }
}

