/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.data.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.foreach.across.modules.webcms.data.json.WebCmsObjectDeserializers;
import com.foreach.across.modules.webcms.data.json.WebCmsObjectSerializer;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Service;

@Service
public final class WebCmsDataObjectMapper {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDataObjectMapper.class);
    private final ObjectMapper objectMapper;
    private final TypeFactory typeFactory;

    public WebCmsDataObjectMapper(WebCmsObjectSerializer cmsObjectSerializer, WebCmsObjectDeserializers cmsObjectDeserializers) {
        SimpleModule jsonModule = new SimpleModule("WebCmsModule");
        jsonModule.addSerializer(WebCmsObject.class, (JsonSerializer)cmsObjectSerializer);
        jsonModule.setDeserializers((SimpleDeserializers)cmsObjectDeserializers);
        this.objectMapper = Jackson2ObjectMapperBuilder.json().locale(Locale.US).indentOutput(false).modules(new Module[]{jsonModule}).failOnUnknownProperties(false).failOnEmptyBeans(false).featuresToEnable(new Object[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE}).build();
        this.typeFactory = this.objectMapper.getTypeFactory();
    }

    public String writeToString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean updateFromString(String json, Object target, boolean failOnError) {
        try {
            this.objectMapper.readerForUpdating(target).readValue(json);
            return true;
        }
        catch (IOException ioe) {
            LOG.error("Exception updating object from JSON - failing: {}", (Object)failOnError, (Object)ioe);
            if (failOnError) {
                throw new RuntimeException(ioe);
            }
            return false;
        }
    }

    public <T> T readFromString(String json, Class<T> valueType) {
        return this.readFromString(json, TypeDescriptor.valueOf(valueType));
    }

    public <T> T readFromString(String json, TypeDescriptor typeDescriptor) {
        return (T)this.objectMapper.readValue(json, this.convertResolvableTypeToJavaType(typeDescriptor.getResolvableType()));
    }

    private JavaType convertResolvableTypeToJavaType(ResolvableType resolvableType) {
        return this.typeFactory.constructSimpleType(resolvableType.resolve(), this.convertResolvableTypeToJavaType(resolvableType.getGenerics()));
    }

    private JavaType[] convertResolvableTypeToJavaType(ResolvableType[] resolvableTypes) {
        JavaType[] javaTypes = new JavaType[resolvableTypes.length];
        for (int i = 0; i < resolvableTypes.length; ++i) {
            javaTypes[i] = this.convertResolvableTypeToJavaType(resolvableTypes[i]);
        }
        return javaTypes;
    }
}

