/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.QWebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import com.querydsl.core.types.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class WebCmsObjectDeleteInterceptor
extends EntityInterceptorAdapter<WebCmsObject> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsObjectDeleteInterceptor.class);
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsTypeSpecifierLinkRepository linkRepository;

    public boolean handles(Class<?> entityClass) {
        return WebCmsObject.class.isAssignableFrom(entityClass);
    }

    public void afterDelete(WebCmsObject entity) {
        this.deleteOwnedComponents(entity);
        this.deleteTypeSpecifierLinks(entity);
    }

    private void deleteOwnedComponents(WebCmsObject entity) {
        this.componentRepository.findAll((Predicate)QWebCmsComponent.webCmsComponent.ownerObjectId.eq((Object)entity.getObjectId())).forEach(component -> {
            LOG.trace("Deleting component {} because owner {} has been deleted", component, (Object)entity);
            this.componentRepository.delete(component);
        });
    }

    private void deleteTypeSpecifierLinks(WebCmsObject entity) {
        this.linkRepository.findAllByOwnerObjectId(entity.getObjectId()).forEach(arg_0 -> ((WebCmsTypeSpecifierLinkRepository)this.linkRepository).delete(arg_0));
    }

    public WebCmsObjectDeleteInterceptor(WebCmsComponentRepository componentRepository, WebCmsTypeSpecifierLinkRepository linkRepository) {
        this.componentRepository = componentRepository;
        this.linkRepository = linkRepository;
    }
}

