/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain;

import com.foreach.across.modules.hibernate.business.SettableIdAuditableEntity;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;

@Access(value=AccessType.FIELD)
@MappedSuperclass
public abstract class WebCmsObjectSuperClass<T extends WebCmsObjectSuperClass<T>>
extends SettableIdAuditableEntity<T>
implements WebCmsObject,
WebCmsDomainBound {
    @Column(name="object_id", unique=true)
    @NotBlank
    @Length(max=100)
    private @NotBlank @Length(max=100) String objectId;
    @ManyToOne
    @JoinColumn(name="domain_id")
    private WebCmsDomain domain;

    protected WebCmsObjectSuperClass() {
        this.setObjectId(UUID.randomUUID().toString());
    }

    protected WebCmsObjectSuperClass(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain) {
        this.setNewEntityId(newEntityId);
        this.setId(id);
        this.setCreatedBy(createdBy);
        if (createdDate != null) {
            this.setCreatedDate(new Date(createdDate.getTime()));
        }
        this.setLastModifiedBy(lastModifiedBy);
        if (lastModifiedDate != null) {
            this.setLastModifiedDate(new Date(lastModifiedDate.getTime()));
        }
        this.setObjectId(StringUtils.isNotEmpty((CharSequence)objectId) ? objectId : UUID.randomUUID().toString());
        this.setDomain(domain);
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    public void setObjectId(String objectId) {
        this.objectId = StringUtils.isEmpty((CharSequence)objectId) ? null : WebCmsUtils.prefixObjectIdForCollection(objectId, this.getObjectCollectionId());
    }

    protected abstract String getObjectCollectionId();

    @Override
    public WebCmsDomain getDomain() {
        return this.domain;
    }

    @Override
    public void setDomain(WebCmsDomain domain) {
        this.domain = domain;
    }
}

