/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.article;

import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@DiscriminatorValue(value="article")
@Table(name="wcm_article")
@NotThreadSafe
public class WebCmsArticle
extends WebCmsAsset<WebCmsArticle> {
    public static final String OBJECT_TYPE = "article";
    public static final String COLLECTION_ID = "wcm:asset:article";
    @NotNull
    @ManyToOne(optional=false)
    @JoinColumn(name="publication_id")
    private WebCmsPublication publication;
    @NotNull
    @ManyToOne(optional=false)
    @JoinColumn(name="article_type_id")
    private WebCmsArticleType articleType;
    @Column(name="title")
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String title;
    @Column(name="sub_title")
    @Length(max=255)
    private @Length(max=255) String subTitle;
    @Column(name="description")
    @Length(max=255)
    private @Length(max=255) String description;

    protected WebCmsArticle(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, boolean published, Date publicationDate, int sortIndex, WebCmsPublication publication, WebCmsArticleType articleType, String title, String subTitle, String description) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain, published, publicationDate, sortIndex);
        this.publication = publication;
        this.articleType = articleType;
        this.title = title;
        this.subTitle = subTitle;
        this.description = description;
    }

    @Override
    public final String getObjectType() {
        return OBJECT_TYPE;
    }

    @Override
    protected final String getObjectCollectionId() {
        return COLLECTION_ID;
    }

    @Override
    public final String getName() {
        return this.getTitle();
    }

    @Override
    public String toString() {
        return "WebCmsArticle{objectId='" + this.getObjectId() + "',title='" + this.title + '\'' + '}';
    }

    @Override
    public WebCmsArticleType getAssetType() {
        return this.getArticleType();
    }

    public static WebCmsArticleBuilder builder() {
        return new WebCmsArticleBuilder();
    }

    public WebCmsArticleBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        WebCmsDomain domain = this.getDomain();
        boolean published = this.isPublished();
        Date publicationDate = this.getPublicationDate();
        int sortIndex = this.getSortIndex();
        return new WebCmsArticleBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).domain(domain).published(published).publicationDate(publicationDate).sortIndex(sortIndex).publication(this.publication).articleType(this.articleType).title(this.title).subTitle(this.subTitle).description(this.description);
    }

    public WebCmsArticle() {
    }

    public WebCmsPublication getPublication() {
        return this.publication;
    }

    public WebCmsArticleType getArticleType() {
        return this.articleType;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public String getDescription() {
        return this.description;
    }

    public void setPublication(WebCmsPublication publication) {
        this.publication = publication;
    }

    public void setArticleType(WebCmsArticleType articleType) {
        this.articleType = articleType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class WebCmsArticleBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private WebCmsDomain domain;
        private boolean published;
        private Date publicationDate;
        private WebCmsPublication publication;
        private WebCmsArticleType articleType;
        private String title;
        private String subTitle;
        private String description;
        private int sortIndex = 1000;

        WebCmsArticleBuilder() {
        }

        public WebCmsArticleBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsArticleBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsArticleBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsArticleBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsArticleBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsArticleBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsArticleBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsArticleBuilder domain(WebCmsDomain domain) {
            this.domain = domain;
            return this;
        }

        public WebCmsArticleBuilder published(boolean published) {
            this.published = published;
            return this;
        }

        public WebCmsArticleBuilder publicationDate(Date publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        public WebCmsArticleBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsArticleBuilder publication(WebCmsPublication publication) {
            this.publication = publication;
            return this;
        }

        public WebCmsArticleBuilder articleType(WebCmsArticleType articleType) {
            this.articleType = articleType;
            return this;
        }

        public WebCmsArticleBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WebCmsArticleBuilder subTitle(String subTitle) {
            this.subTitle = subTitle;
            return this;
        }

        public WebCmsArticleBuilder description(String description) {
            this.description = description;
            return this;
        }

        public WebCmsArticle build() {
            return new WebCmsArticle(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.domain, this.published, this.publicationDate, this.sortIndex, this.publication, this.articleType, this.title, this.subTitle, this.description);
        }

        public String toString() {
            return "WebCmsArticle.WebCmsArticleBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", domain=" + this.domain + ", published=" + this.published + ", publicationDate=" + this.publicationDate + ", sortIndex=" + this.sortIndex + ", publication=" + this.publication + ", articleType=" + this.articleType + ", title=" + this.title + ", subTitle=" + this.subTitle + ", description=" + this.description + ")";
        }
    }
}

