/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.article;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticle;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.type.WebCmsDefaultComponentsService;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class WebCmsArticleInterceptor
extends EntityInterceptorAdapter<WebCmsArticle> {
    private final WebCmsDefaultComponentsService webCmsTypeComponentsStrategy;
    private final WebCmsEndpointService endpointService;

    public boolean handles(Class<?> entityClass) {
        return WebCmsArticle.class.isAssignableFrom(entityClass);
    }

    public void afterCreate(WebCmsArticle entity) {
        this.createDefaultComponents(entity);
        this.endpointService.updateOrCreatePrimaryUrlForAsset(this.generateUrl(entity), entity, true);
    }

    private void createDefaultComponents(WebCmsArticle entity) {
        HashMap<String, String> markerValues = new HashMap<String, String>();
        markerValues.put("@@title@@", entity.getTitle());
        markerValues.put("@@subTitle@@", entity.getSubTitle());
        markerValues.put("@@description@@", entity.getDescription());
        this.webCmsTypeComponentsStrategy.createDefaultComponents(entity, markerValues);
    }

    public void afterUpdate(WebCmsArticle entity) {
        this.endpointService.updateOrCreatePrimaryUrlForAsset(this.generateUrl(entity), entity, true);
    }

    private String generateUrl(WebCmsArticle article) {
        WebCmsPage articleTemplatePage = article.getPublication().getArticleTemplatePage();
        if (articleTemplatePage != null) {
            return WebCmsUtils.combineUrlSegments(articleTemplatePage.getCanonicalPath(), WebCmsUtils.generateUrlPathSegment(article.getTitle()));
        }
        return "/" + WebCmsUtils.generateUrlPathSegment(article.getTitle());
    }

    public WebCmsArticleInterceptor(WebCmsDefaultComponentsService webCmsTypeComponentsStrategy, WebCmsEndpointService endpointService) {
        this.webCmsTypeComponentsStrategy = webCmsTypeComponentsStrategy;
        this.endpointService = endpointService;
    }
}

