/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.article.web;

import com.foreach.across.modules.bootstrapui.elements.Grid;
import com.foreach.across.modules.bootstrapui.elements.builder.OptionFormElementBuilder;
import com.foreach.across.modules.entity.EntityAttributes;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.bootstrapui.options.OptionIterableBuilder;
import com.foreach.across.modules.entity.views.processors.SingleEntityFormViewProcessor;
import com.foreach.across.modules.entity.views.util.EntityViewElementUtils;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticle;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.article.web.ArticleCreateFormProcessor;
import com.foreach.across.modules.webcms.domain.article.web.ArticleUpdateFormProcessor;
import com.foreach.across.modules.webcms.domain.article.web.WebCmsArticleListViewProcessor;
import com.foreach.across.modules.webcms.domain.asset.web.processors.WebCmsAssetListViewProcessor;
import com.foreach.across.modules.webcms.domain.component.web.WebCmsComponentsFormProcessor;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import java.util.ArrayList;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Configuration
public class WebCmsArticleAdminConfiguration {

    @ConditionalOnAdminUI
    @Component
    static class ArticleTypeForPublicationIterableBuilder
    implements OptionIterableBuilder {
        private final WebCmsTypeSpecifierLinkRepository linkRepository;

        public Iterable<OptionFormElementBuilder> buildOptions(ViewElementBuilderContext builderContext) {
            ArrayList<OptionFormElementBuilder> options = new ArrayList<OptionFormElementBuilder>();
            WebCmsArticle article = (WebCmsArticle)EntityViewElementUtils.currentEntity((ViewElementBuilderContext)builderContext, WebCmsArticle.class);
            WebCmsPublication publication = article.getPublication();
            if (publication != null) {
                this.linkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(publication.getPublicationType().getObjectId(), "article").stream().map(WebCmsTypeSpecifierLink::getTypeSpecifier).forEach(type -> options.add(new OptionFormElementBuilder().rawValue(type).label(type.getName()).value((Object)type.getId())));
            }
            return options;
        }

        public ArticleTypeForPublicationIterableBuilder(WebCmsTypeSpecifierLinkRepository linkRepository) {
            this.linkRepository = linkRepository;
        }
    }

    @ConditionalOnAdminUI
    @Configuration
    static class ArticleAdminUi
    implements EntityConfigurer {
        private final WebCmsComponentsFormProcessor componentsFormProcessor;
        private final ArticleCreateFormProcessor createFormProcessor;
        private final ArticleUpdateFormProcessor updateFormProcessor;
        private final ArticleTypeForPublicationIterableBuilder articleTypeForPublicationIterableBuilder;

        public void configure(EntitiesConfigurationBuilder entities) {
            this.componentsFormProcessor.setComponentNames("content");
            entities.withType(WebCmsArticleType.class).association(ab -> ab.name("webCmsArticle.articleType").listView(lvb -> lvb.showProperties(new String[]{"publication", "title", "publicationDate", "lastModified"}).viewProcessor((EntityViewProcessor)new WebCmsAssetListViewProcessor())));
            entities.withType(WebCmsArticle.class).properties(props -> props.property("objectId").hidden(true).and().property("body").hidden(true).and().property("image").hidden(true).and().property("title").viewElementType(ViewElementMode.CONTROL, "bootstrapTextarea").and().property("subTitle").viewElementType(ViewElementMode.CONTROL, "bootstrapTextarea").and().property("description").viewElementType(ViewElementMode.CONTROL, "bootstrapTextarea").and().property("publication").attribute(EntityAttributes.OPTIONS_ENTITY_QUERY, (Object)"published = TRUE")).listView(lvb -> lvb.showProperties(new String[]{"publication", "title", "articleType", "publicationDate", "lastModified"}).defaultSort(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastModifiedDate"})).entityQueryPredicate("publication.published = true").viewProcessor((EntityViewProcessor)new WebCmsArticleListViewProcessor())).createOrUpdateFormView(fvb -> fvb.properties(props -> props.property("articleType").attribute(OptionIterableBuilder.class, (Object)this.articleTypeForPublicationIterableBuilder))).createFormView(fvb -> fvb.showProperties(new String[]{".", "~subTitle", "~publish-settings"}).viewProcessor((EntityViewProcessor)this.createFormProcessor)).updateFormView(fvb -> fvb.properties(props -> props.property("publication").writable(false).and().property("articleType").writable(false)).showProperties(new String[]{".", "publication", "articleType"}).postProcess(SingleEntityFormViewProcessor.class, processor -> processor.setGrid(Grid.create((int[])new int[]{9, 3}))).viewProcessor((EntityViewProcessor)this.updateFormProcessor).viewProcessor((EntityViewProcessor)this.componentsFormProcessor));
        }

        public ArticleAdminUi(WebCmsComponentsFormProcessor componentsFormProcessor, ArticleCreateFormProcessor createFormProcessor, ArticleUpdateFormProcessor updateFormProcessor, ArticleTypeForPublicationIterableBuilder articleTypeForPublicationIterableBuilder) {
            this.componentsFormProcessor = componentsFormProcessor;
            this.createFormProcessor = createFormProcessor;
            this.updateFormProcessor = updateFormProcessor;
            this.articleTypeForPublicationIterableBuilder = articleTypeForPublicationIterableBuilder;
        }
    }
}

