/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.article.web;

import com.foreach.across.modules.web.mvc.condition.AbstractCustomRequestCondition;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticle;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.article.web.WebCmsArticleMapping;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointContextResolver;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.WebCmsConditionUtils;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationType;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

class WebCmsArticleCondition
extends AbstractCustomRequestCondition<WebCmsArticleCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsArticleCondition.class);
    private final ConfigurableWebCmsEndpointContext context;
    private final WebCmsEndpointContextResolver resolver;
    String[] articleTypes = new String[0];
    String[] publicationTypes = new String[0];
    String[] publications = new String[0];
    private String[] objectIds = new String[0];

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        WebCmsArticleMapping articleMapping = (WebCmsArticleMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, WebCmsArticleMapping.class);
        this.articleTypes = articleMapping.articleType();
        this.publicationTypes = articleMapping.publicationType();
        this.publications = articleMapping.publication();
        this.objectIds = articleMapping.objectId();
    }

    protected Collection<?> getContent() {
        return Arrays.asList(this.articleTypes, this.publicationTypes, this.publications);
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public WebCmsArticleCondition combine(WebCmsArticleCondition other) {
        WebCmsArticleCondition result = new WebCmsArticleCondition(this.context, this.resolver);
        result.articleTypes = WebCmsConditionUtils.combineArrays(this.articleTypes, other.articleTypes);
        result.publicationTypes = WebCmsConditionUtils.combineArrays(this.publicationTypes, other.publicationTypes);
        result.publications = WebCmsConditionUtils.combineArrays(this.publications, other.publications);
        result.objectIds = WebCmsConditionUtils.combineArrays(this.objectIds, other.objectIds);
        return result;
    }

    public WebCmsArticleCondition getMatchingCondition(HttpServletRequest request) {
        WebCmsArticle article;
        if (!this.context.isResolved()) {
            this.resolver.resolve(this.context, request);
        }
        if ((article = this.retrieveArticle()) != null) {
            if (!(this.isValidArticleType(article) && this.isValidPublicationType(article) && this.isValidPublication(article))) {
                return null;
            }
            LOG.trace("Matching WebCmsArticleCondition: {}", (Object)this);
            return this;
        }
        return null;
    }

    private boolean isValidPublication(WebCmsArticle article) {
        if (this.publications.length > 0) {
            WebCmsPublication publication = article.getPublication();
            return publication != null && (ArrayUtils.contains((Object[])this.publications, (Object)publication.getPublicationKey()) || ArrayUtils.contains((Object[])this.publications, (Object)publication.getObjectId()));
        }
        return true;
    }

    private boolean isValidPublicationType(WebCmsArticle article) {
        if (this.publicationTypes.length > 0) {
            WebCmsPublication publication = article.getPublication();
            WebCmsPublicationType publicationType = publication != null ? publication.getPublicationType() : null;
            return publicationType != null && (ArrayUtils.contains((Object[])this.publicationTypes, (Object)publicationType.getTypeKey()) || ArrayUtils.contains((Object[])this.publicationTypes, (Object)publicationType.getObjectId()));
        }
        return true;
    }

    private boolean isValidArticleType(WebCmsArticle article) {
        if (this.articleTypes.length > 0) {
            WebCmsArticleType articleType = article.getArticleType();
            return articleType != null && (ArrayUtils.contains((Object[])this.articleTypes, (Object)articleType.getTypeKey()) || ArrayUtils.contains((Object[])this.articleTypes, (Object)articleType.getObjectId()));
        }
        return true;
    }

    private WebCmsArticle retrieveArticle() {
        if (this.context.isOfType(WebCmsAssetEndpoint.class)) {
            WebCmsAssetEndpoint endpoint = this.context.getEndpoint(WebCmsAssetEndpoint.class);
            return endpoint.getAsset() instanceof WebCmsArticle ? (WebCmsArticle)endpoint.getAsset() : null;
        }
        return null;
    }

    public int compareTo(WebCmsArticleCondition other, HttpServletRequest request) {
        int val2 = WebCmsConditionUtils.compareArrays(this.objectIds, other.objectIds);
        if (val2 == 0) {
            val2 = WebCmsConditionUtils.compareArrays(this.publications, other.publications);
        }
        if (val2 == 0) {
            val2 = WebCmsConditionUtils.compareArrays(this.publicationTypes, other.publicationTypes);
        }
        if (val2 == 0) {
            val2 = WebCmsConditionUtils.compareArrays(this.articleTypes, other.articleTypes);
        }
        return val2;
    }

    public WebCmsArticleCondition(ConfigurableWebCmsEndpointContext context, WebCmsEndpointContextResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }
}

