/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.article.web;

import com.foreach.across.modules.webcms.domain.article.WebCmsArticle;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.web.AbstractWebCmsAssetModelLoader;
import com.foreach.across.modules.webcms.domain.endpoint.web.interceptor.WebCmsEndpointHandlerInterceptor;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.web.PageTemplateResolver;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;

@Component
@Order(value=0x7FFFFFFD)
public class WebCmsArticleModelLoader
extends AbstractWebCmsAssetModelLoader<WebCmsArticle> {
    private final PageTemplateResolver pageTemplateResolver;

    @Override
    protected boolean supports(WebCmsAsset<?> asset) {
        return asset instanceof WebCmsArticle;
    }

    @Override
    protected boolean loadModel(HttpServletRequest request, WebCmsArticle article, Model model) {
        WebCmsPage page = article.getPublication().getArticleTemplatePage();
        if (page != null) {
            model.addAttribute(page.getObjectType(), (Object)page);
            this.registerAssetComponentsForScope(page, page.getObjectType(), false);
            this.registerDefaultTemplate(request, page);
        }
        model.addAttribute("asset", (Object)article);
        model.addAttribute(article.getObjectType(), (Object)article);
        model.addAttribute(article.getPublication().getObjectType(), (Object)article.getPublication());
        this.registerAssetComponentsForScope(article, article.getObjectType(), true);
        return false;
    }

    private void registerDefaultTemplate(HttpServletRequest request, WebCmsPage page) {
        request.setAttribute(WebCmsEndpointHandlerInterceptor.DEFAULT_TEMPLATE_ATTRIBUTE, (Object)this.pageTemplateResolver.resolvePageTemplate(page));
    }

    public WebCmsArticleModelLoader(PageTemplateResolver pageTemplateResolver) {
        this.pageTemplateResolver = pageTemplateResolver;
    }
}

