/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.WebCmsObjectSuperClass;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractWebCmsAssetImporter<T extends WebCmsAsset>
extends AbstractWebCmsDataImporter<T, T> {
    private final String dataKey;
    private final Class<T> assetType;
    private WebCmsAssetRepository assetRepository;

    protected AbstractWebCmsAssetImporter(@NonNull String dataKey, @NonNull Class<T> assetType) {
        if (dataKey == null) {
            throw new NullPointerException("dataKey is marked non-null but is null");
        }
        if (assetType == null) {
            throw new NullPointerException("assetType is marked non-null but is null");
        }
        this.dataKey = dataKey;
        this.assetType = assetType;
    }

    @Override
    public final boolean supports(WebCmsDataEntry data) {
        return data.getParent() != null && "assets".equals(data.getParent().getParentKey()) && this.dataKey.equals(data.getParentKey());
    }

    @Override
    protected final T retrieveExistingInstance(WebCmsDataEntry item) {
        String objectId = (String)item.getMapData().get("objectId");
        String entryKey = item.getKey();
        WebCmsAsset existing = null;
        if (objectId != null) {
            this.validateObjectId(objectId);
            existing = this.assetRepository.findOneByObjectId(objectId).orElse(null);
        }
        WebCmsDomain domain = this.retrieveDomainForDataEntry(item, this.assetType);
        return (T)(existing != null ? (WebCmsAsset)this.assetType.cast(existing) : this.getExistingEntity(entryKey, item, domain));
    }

    protected void validateObjectId(String objectId) {
        WebCmsAsset asset = (WebCmsAsset)this.assetType.newInstance();
        asset.setObjectId(objectId);
        if (!StringUtils.equals((CharSequence)asset.getObjectId(), (CharSequence)objectId)) {
            this.LOG.error("Invalid objectId specified: {} would be converted to {}, only fully qualified object ids are supported", (Object)objectId, (Object)asset.getObjectId());
            throw new IllegalArgumentException("Invalid objectId: " + objectId + " - only fully qualified object ids are supported, value would be converted to " + asset.getObjectId());
        }
    }

    @Override
    protected void deleteInstance(T instance, WebCmsDataEntry data) {
        this.assetRepository.delete(instance);
    }

    @Override
    protected void saveDto(T itemToSave, WebCmsDataAction action, WebCmsDataEntry data) {
        this.LOG.debug("Saving WebCmsAsset {} with objectId {} (insert: {}) - {}", new Object[]{this.dataKey, ((WebCmsObjectSuperClass)itemToSave).getObjectId(), itemToSave.isNew(), itemToSave});
        this.assetRepository.save(itemToSave);
    }

    protected T getExistingEntity(String entryKey, WebCmsDataEntry entryData, WebCmsDomain domain) {
        return null;
    }

    @Autowired
    public void setAssetRepository(WebCmsAssetRepository assetRepository) {
        this.assetRepository = assetRepository;
    }
}

