/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetRepository;
import com.foreach.across.modules.webcms.domain.page.services.WebCmsPageService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.stereotype.Component;

@Component
public class StringToWebCmsAssetConverter
implements ConverterFactory<String, WebCmsAsset> {
    private final WebCmsAssetRepository assetRepository;
    private final WebCmsPageService pageService;

    @Autowired
    void registerToConversionService(WebCmsDataConversionService conversionService) {
        conversionService.addConverterFactory(this);
    }

    @Autowired
    void registerToMvcConversionService(@Qualifier(value="mvcConversionService") ConverterRegistry mvcConversionService) {
        mvcConversionService.addConverterFactory((ConverterFactory)this);
    }

    public <T extends WebCmsAsset> Converter<String, T> getConverter(Class<T> targetType) {
        return id -> {
            if (NumberUtils.isDigits((String)id)) {
                return this.assetRepository.findById(Long.parseLong(id)).map(targetType::cast).orElse(null);
            }
            if (id.startsWith("/")) {
                return (WebCmsAsset)targetType.cast(this.pageService.findByCanonicalPath((String)id).orElse(null));
            }
            return StringUtils.isEmpty((CharSequence)id) ? null : (WebCmsAsset)this.assetRepository.findOneByObjectId((String)id).map(targetType::cast).orElse(null);
        };
    }

    public StringToWebCmsAssetConverter(WebCmsAssetRepository assetRepository, WebCmsPageService pageService) {
        this.assetRepository = assetRepository;
        this.pageService = pageService;
    }
}

