/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.webcms.domain.WebCmsObjectInheritanceSuperClass;
import com.foreach.across.modules.webcms.domain.asset.web.WebCmsAssetType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Table(name="wcm_asset")
@Access(value=AccessType.FIELD)
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="object_type", discriminatorType=DiscriminatorType.STRING)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NotThreadSafe
public abstract class WebCmsAsset<T extends WebCmsAsset<T>>
extends WebCmsObjectInheritanceSuperClass<T> {
    @Id
    @GeneratedValue(generator="seq_wcm_asset_id")
    @GenericGenerator(name="seq_wcm_asset_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_asset_id"), @Parameter(name="allocationSize", value="5")})
    private Long id;
    @Column(name="published")
    private boolean published;
    @Column(name="publication_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date publicationDate;
    @Column(name="sort_index")
    private int sortIndex = 1000;

    public WebCmsAsset() {
    }

    protected WebCmsAsset(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, boolean published, Date publicationDate, int sortIndex) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain);
        this.setPublished(published);
        this.setPublicationDate(publicationDate);
        this.setSortIndex(sortIndex);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPublicationDate(Date publicationDate) {
        if (publicationDate != null) {
            this.publicationDate = new Date(publicationDate.getTime());
        }
    }

    public abstract String getName();

    public String toString() {
        return this.getClass().getSimpleName() + "{objectId='" + this.getObjectId() + '\'' + '}';
    }

    @Transient
    public abstract WebCmsAssetType getAssetType();

    public boolean isPublished() {
        return this.published;
    }

    public Date getPublicationDate() {
        return this.publicationDate;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setPublished(boolean published) {
        this.published = published;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }
}

