/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.foreach.across.modules.webcms.domain.url.config.WebCmsAssetUrlConfiguration;
import java.util.Date;
import java.util.Optional;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Order(value=-2147483648)
@Component
public class WebCmsAssetInterceptor
extends EntityInterceptorAdapter<WebCmsAsset> {
    private final WebCmsAssetEndpointRepository endpointRepository;
    private final WebCmsAssetUrlConfiguration urlConfiguration;
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;

    public boolean handles(Class<?> entityClass) {
        return WebCmsAsset.class.isAssignableFrom(entityClass);
    }

    public void beforeCreate(WebCmsAsset entity) {
        this.setPublicationDate(entity);
    }

    public void beforeUpdate(WebCmsAsset entity) {
        this.setPublicationDate(entity);
    }

    private void setPublicationDate(WebCmsAsset asset) {
        if (asset.isPublished() && asset.getPublicationDate() == null) {
            asset.setPublicationDate(new Date());
        }
    }

    public void afterCreate(WebCmsAsset entity) {
        if (this.urlConfiguration.isEnabledForAsset(entity)) {
            WebCmsAssetEndpoint<WebCmsAsset> endpoint = new WebCmsAssetEndpoint<WebCmsAsset>();
            endpoint.setAsset(entity);
            if (this.multiDomainConfiguration.isDomainBound(WebCmsAssetEndpoint.class)) {
                endpoint.setDomain(entity.getDomain());
            }
            this.endpointRepository.save(endpoint);
        }
    }

    public void afterUpdate(WebCmsAsset entity) {
        WebCmsDomain domain;
        Optional<WebCmsAssetEndpoint> endpoint;
        if (this.urlConfiguration.isEnabledForAsset(entity) && !(endpoint = this.endpointRepository.findOneByAssetAndDomain(entity, domain = this.multiDomainConfiguration.isDomainBound(WebCmsAssetEndpoint.class) ? entity.getDomain() : WebCmsDomain.NONE)).isPresent()) {
            this.afterCreate(entity);
        }
    }

    public void beforeDelete(WebCmsAsset entity) {
        if (this.urlConfiguration.isEnabledForAsset(entity)) {
            this.endpointRepository.findAllByAsset(entity).forEach(arg_0 -> ((WebCmsAssetEndpointRepository)this.endpointRepository).delete(arg_0));
        }
    }

    public WebCmsAssetInterceptor(WebCmsAssetEndpointRepository endpointRepository, WebCmsAssetUrlConfiguration urlConfiguration, WebCmsMultiDomainConfiguration multiDomainConfiguration) {
        this.endpointRepository = endpointRepository;
        this.urlConfiguration = urlConfiguration;
        this.multiDomainConfiguration = multiDomainConfiguration;
    }
}

