/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.hibernate.business.SettableIdAuditableEntity;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_object_asset_link")
@Access(value=AccessType.FIELD)
@NotThreadSafe
public class WebCmsAssetLink
extends SettableIdAuditableEntity<WebCmsAssetLink> {
    @Id
    @GeneratedValue(generator="seq_wcm_object_asset_link_id")
    @GenericGenerator(name="seq_wcm_object_asset_link_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_object_asset_link_id"), @Parameter(name="allocationSize", value="5")})
    private Long id;
    @Column(name="owner_object_id")
    @Length(max=100)
    private @Length(max=100) String ownerObjectId;
    @NotNull
    @ManyToOne
    @JoinColumn(name="asset_id")
    private WebCmsAsset asset;
    @Column(name="link_type")
    @Length(max=255)
    @Length(max=255) String linkType;
    @Column(name="sort_index")
    private int sortIndex;

    public WebCmsAssetLink() {
    }

    protected WebCmsAssetLink(Long id, Long newEntityId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsAsset asset, String linkType, int sortIndex) {
        this.setId(id);
        this.setNewEntityId(newEntityId);
        this.setCreatedBy(createdBy);
        this.setCreatedDate(createdDate);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDate(lastModifiedDate);
        this.setAsset(asset);
        this.setLinkType(linkType);
        this.setSortIndex(sortIndex);
    }

    public void setOwner(WebCmsObject owner) {
        this.setOwnerObjectId(owner != null ? owner.getObjectId() : null);
    }

    public <U extends WebCmsAsset<U>> U getAsset(Class<U> assetType) {
        return (U)((WebCmsAsset)assetType.cast(this.getAsset()));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{ownerObjectId='" + this.ownerObjectId + '\'' + ", asset=" + this.asset + ", linkType='" + this.linkType + '\'' + '}';
    }

    public Long getId() {
        return this.id;
    }

    public String getOwnerObjectId() {
        return this.ownerObjectId;
    }

    public WebCmsAsset getAsset() {
        return this.asset;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOwnerObjectId(String ownerObjectId) {
        this.ownerObjectId = ownerObjectId;
    }

    public void setAsset(WebCmsAsset asset) {
        this.asset = asset;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }
}

