/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetLink;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetLinkRepository;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class WebCmsAssetLinkPropertyDataImporter
implements WebCmsPropertyDataImporter<WebCmsObject> {
    public static final String PROPERTY_NAME = "wcm:assets";
    private final WebCmsDataConversionService conversionService;
    private final WebCmsAssetLinkRepository assetLinkRepository;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsObject;
    }

    @Override
    public boolean importData(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry propertyData, WebCmsObject asset, WebCmsDataAction action) {
        WebCmsAssetLink assetLink = new WebCmsAssetLink();
        this.conversionService.convertToPropertyValues(propertyData.getMapData(), (Object)assetLink);
        assetLink.setOwner(asset);
        Optional<WebCmsAssetLink> existing = this.assetLinkRepository.findOneByOwnerObjectIdAndLinkTypeAndAsset(assetLink.getOwnerObjectId(), assetLink.getLinkType(), assetLink.getAsset());
        if (!existing.isPresent()) {
            this.assetLinkRepository.save((Object)assetLink);
        }
        return true;
    }

    public WebCmsAssetLinkPropertyDataImporter(WebCmsDataConversionService conversionService, WebCmsAssetLinkRepository assetLinkRepository) {
        this.conversionService = conversionService;
        this.assetLinkRepository = assetLinkRepository;
    }
}

