/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsUriComponentsService;
import java.util.Optional;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class WebCmsAssetServiceImpl
implements WebCmsAssetService {
    private final WebCmsUriComponentsService uriComponentsService;
    private final WebCmsEndpointService endpointService;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsMultiDomainService multiDomainService;

    @Override
    @Transactional(readOnly=true)
    public Optional<String> buildPreviewUrl(WebCmsAsset asset) {
        Assert.notNull((Object)asset, (String)"asset is required");
        return this.buildPreviewUrlOnDomain(asset, this.multiDomainService.getCurrentDomainForEntity(asset));
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<String> buildPreviewUrlOnDomain(WebCmsAsset asset, WebCmsDomain domain) {
        Assert.notNull((Object)asset, (String)"asset is required");
        return this.getUriComponents(asset, domain).map(UriComponentsBuilder::toUriString);
    }

    private Optional<UriComponentsBuilder> getUriComponents(WebCmsAsset asset, WebCmsDomain domain) {
        WebCmsAssetEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(asset, domain).orElse(null);
        return this.uriComponentsService.buildUriComponents(endpoint, domain).map(uriComponents -> this.endpointService.appendPreviewCode(endpoint, (UriComponentsBuilder)uriComponents));
    }

    public WebCmsAssetServiceImpl(WebCmsUriComponentsService uriComponentsService, WebCmsEndpointService endpointService, WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsMultiDomainService multiDomainService) {
        this.uriComponentsService = uriComponentsService;
        this.endpointService = endpointService;
        this.assetEndpointRepository = assetEndpointRepository;
        this.multiDomainService = multiDomainService;
    }
}

