/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset.config;

import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.registry.properties.EntityPropertySelector;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetLink;
import com.foreach.across.modules.webcms.domain.asset.web.builders.WebCmsAssetEndpointViewElementBuilder;
import com.foreach.across.modules.webcms.domain.asset.web.processors.WebCmsAssetListViewProcessor;
import java.util.Locale;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.Printer;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Configuration
class WebCmsAssetConfiguration
implements EntityConfigurer {
    private final WebCmsAssetEndpointViewElementBuilder assetEndpointViewElementBuilder;
    private final AssetEndpointLabelPrinter assetEndpointLabelPrinter;

    public void configure(EntitiesConfigurationBuilder entities) {
        entities.withType(WebCmsAssetLink.class).hide();
        entities.withType(WebCmsAssetEndpoint.class).entityModel(model -> model.labelPrinter((Printer)this.assetEndpointLabelPrinter)).attribute("endpointValueBuilder", (Object)this.assetEndpointViewElementBuilder).hide();
        entities.assignableTo(WebCmsAsset.class).properties(props -> props.property("sortIndex").hidden(true).and().property("published").hidden(true).and().property("publicationDate").hidden(true).and().property("publish-settings").writable(true).readable(false).displayName("Publish settings").viewElementType(ViewElementMode.FORM_WRITE, "bootstrapFieldset").viewElementType(ViewElementMode.FORM_READ, "bootstrapFieldset").attribute("com.foreach.across.modules.bootstrapui.elements.FieldsetFormElement.EntityPropertySelector", (Object)EntityPropertySelector.of((String[])new String[]{"published", "publicationDate"}))).updateFormView(fvb -> fvb.showProperties(new String[]{".", "~created"}).viewProcessor((EntityViewProcessor)new WebCmsAssetViewProcessor())).listView(lvb -> lvb.viewProcessor((EntityViewProcessor)new WebCmsAssetListViewProcessor()));
    }

    public WebCmsAssetConfiguration(WebCmsAssetEndpointViewElementBuilder assetEndpointViewElementBuilder, AssetEndpointLabelPrinter assetEndpointLabelPrinter) {
        this.assetEndpointViewElementBuilder = assetEndpointViewElementBuilder;
        this.assetEndpointLabelPrinter = assetEndpointLabelPrinter;
    }

    static class WebCmsAssetViewProcessor
    extends EntityViewProcessorAdapter {
        WebCmsAssetViewProcessor() {
        }

        protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
            ContainerViewElementUtils.move((ContainerViewElement)container, (String)"formGroup-sortIndex", (String)"publish-settings");
        }
    }

    @ConditionalOnAdminUI
    @Component
    private static class AssetEndpointLabelPrinter
    implements Printer<WebCmsAssetEndpoint> {
        private final EntityRegistry entityRegistry;

        public String print(WebCmsAssetEndpoint endpoint, Locale locale) {
            Object asset = endpoint.getAsset();
            EntityConfiguration entityConfiguration = this.entityRegistry.getEntityConfiguration(asset);
            String name = entityConfiguration.getEntityMessageCodeResolver().getNameSingular();
            return name + ": " + entityConfiguration.getLabel(asset);
        }

        public AssetEndpointLabelPrinter(EntityRegistry entityRegistry) {
            this.entityRegistry = entityRegistry;
        }
    }
}

