/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset.web;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelSet;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointModelLoader;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.WebCmsEndpointContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;

public abstract class AbstractWebCmsAssetModelLoader<T extends WebCmsAsset>
implements WebCmsEndpointModelLoader {
    private WebCmsComponentModelService componentModelService;
    private WebCmsComponentModelHierarchy componentModelHierarchy;

    @Override
    public final boolean loadModel(HttpServletRequest request, WebCmsEndpointContext endpointContext, Model model) {
        Object asset;
        if (endpointContext.isOfType(WebCmsAssetEndpoint.class) && this.supports((WebCmsAsset<?>)(asset = endpointContext.getEndpoint(WebCmsAssetEndpoint.class).getAsset()))) {
            return this.loadModel(request, asset, model);
        }
        return true;
    }

    protected abstract boolean supports(WebCmsAsset<?> var1);

    protected abstract boolean loadModel(HttpServletRequest var1, T var2, Model var3);

    protected void registerAssetComponentsForScope(WebCmsAsset owner, String scope, boolean isMainAsset) {
        WebCmsComponentModelSet componentModelSet = this.componentModelService.buildComponentModelSetForOwner(owner, false);
        this.componentModelHierarchy.registerComponentsForScope(componentModelSet, scope);
        if (isMainAsset) {
            this.componentModelHierarchy.registerAliasForScope("asset", scope);
        }
    }

    @Autowired
    public void setComponentModelService(WebCmsComponentModelService componentModelService) {
        this.componentModelService = componentModelService;
    }

    @Autowired
    public void setComponentModelHierarchy(WebCmsComponentModelHierarchy componentModelHierarchy) {
        this.componentModelHierarchy = componentModelHierarchy;
    }
}

