/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset.web;

import com.foreach.across.modules.web.mvc.condition.AbstractCustomRequestCondition;
import com.foreach.across.modules.webcms.domain.WebCmsObjectSuperClass;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.web.WebCmsAssetMapping;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointContextResolver;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.InvalidWebCmsConditionCombination;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class WebCmsAssetCondition
extends AbstractCustomRequestCondition<WebCmsAssetCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsAssetCondition.class);
    private final ConfigurableWebCmsEndpointContext context;
    private final WebCmsEndpointContextResolver resolver;
    private Class<?> assetType;
    protected String[] objectId = new String[0];

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        WebCmsAssetMapping endpointMapping = (WebCmsAssetMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, WebCmsAssetMapping.class);
        this.assetType = endpointMapping.value();
        this.objectId = endpointMapping.objectId();
    }

    protected Collection<?> getContent() {
        return Arrays.asList(this.assetType, this.objectId);
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public WebCmsAssetCondition combine(WebCmsAssetCondition other) {
        WebCmsAssetCondition result = new WebCmsAssetCondition(this.context, this.resolver);
        if (this.assetType.isAssignableFrom(other.assetType)) {
            result.assetType = other.assetType;
        } else {
            if (!other.assetType.isAssignableFrom(this.assetType)) {
                String message = String.format("A condition with asset type %s and type %s cannot be merged", this.assetType, other.assetType);
                throw new InvalidWebCmsConditionCombination(message);
            }
            result.assetType = this.assetType;
        }
        result.objectId = this.combineObjectIds(other);
        return result;
    }

    private String[] combineObjectIds(WebCmsAssetCondition other) {
        if (this.objectId.length == 0 && other.objectId.length == 0) {
            return new String[0];
        }
        if (this.objectId.length == 0) {
            return other.objectId;
        }
        if (other.objectId.length == 0) {
            return this.objectId;
        }
        ArrayList<String> combined = new ArrayList<String>();
        for (String otherObjectId : other.objectId) {
            if (!ArrayUtils.contains((Object[])this.objectId, (Object)otherObjectId)) {
                throw new InvalidWebCmsConditionCombination(String.format("Current objectid collection does not contain [%s]", otherObjectId));
            }
            combined.add(otherObjectId);
        }
        return combined.toArray(new String[combined.size()]);
    }

    public WebCmsAssetCondition getMatchingCondition(HttpServletRequest request) {
        if (!this.context.isResolved()) {
            this.resolver.resolve(this.context, request);
        }
        if (!this.context.isOfType(WebCmsAssetEndpoint.class)) {
            return null;
        }
        Object asset = this.context.getEndpoint(WebCmsAssetEndpoint.class).getAsset();
        WebCmsAssetCondition result = new WebCmsAssetCondition(this.context, this.resolver);
        if (this.assetType.isInstance(asset)) {
            result.assetType = this.assetType;
            if (this.objectId.length == 0) {
                return result;
            }
            if (ArrayUtils.contains((Object[])this.objectId, (Object)((WebCmsObjectSuperClass)asset).getObjectId())) {
                result.objectId = this.objectId;
                LOG.trace("Matching condition is [{}] with objectId [{}]", result.assetType, (Object)result.objectId);
                return result;
            }
        }
        return null;
    }

    public int compareTo(WebCmsAssetCondition other, HttpServletRequest request) {
        if (this.objectId.length > 0 && other.objectId.length == 0) {
            return -1;
        }
        if (this.objectId.length == 0 && other.objectId.length > 0) {
            return 1;
        }
        if (this.objectId.length > 0 || other.objectId.length > 0) {
            return Integer.compare(this.objectId.length, other.objectId.length);
        }
        if (this.assetType != null && other.assetType != null && !this.assetType.equals(other.assetType)) {
            return this.assetType.isAssignableFrom(other.assetType) ? 1 : -1;
        }
        return 0;
    }

    public WebCmsAssetCondition(ConfigurableWebCmsEndpointContext context, WebCmsEndpointContextResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }
}

