/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset.web;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointAccessValidator;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFF)
public class WebCmsAssetEndpointAccessValidator<T extends WebCmsAsset>
implements WebCmsEndpointAccessValidator<WebCmsAssetEndpoint<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsAssetEndpointAccessValidator.class);

    @Override
    public boolean appliesFor(WebCmsEndpoint endpoint) {
        return endpoint instanceof WebCmsAssetEndpoint;
    }

    @Override
    public boolean validateAccess(WebCmsAssetEndpoint<T> endpoint) {
        return this.validateAccess((WebCmsAsset)endpoint.getAsset());
    }

    @Override
    protected final boolean validateAccess(WebCmsAsset asset) {
        if (asset.isPublished()) {
            if (asset.getPublicationDate() == null || asset.getPublicationDate().before(new Date())) {
                return true;
            }
            LOG.trace("WebCmsAsset {} is published but publication date {} is in the future - denying access", (Object)asset, (Object)asset.getPublicationDate());
        } else {
            LOG.trace("WebCmsAsset {} is not published - denying access", (Object)asset);
        }
        return false;
    }
}

