/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.asset.web;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.web.WebCmsAssetMapping;
import com.foreach.across.modules.webcms.domain.endpoint.web.IgnoreEndpointModel;
import com.foreach.across.modules.webcms.domain.endpoint.web.interceptor.WebCmsEndpointHandlerInterceptor;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.view.RedirectView;

@Controller
class WebCmsAssetEndpointController {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsAssetEndpointController.class);

    WebCmsAssetEndpointController() {
    }

    @WebCmsAssetMapping
    public String renderAsset(HttpServletRequest request, WebCmsAsset asset) {
        LOG.trace("Using default asset rendering handler method for {}", (Object)asset);
        String defaultViewName = (String)request.getAttribute(WebCmsEndpointHandlerInterceptor.DEFAULT_TEMPLATE_ATTRIBUTE);
        return defaultViewName != null ? defaultViewName : "asset/" + asset.getObjectType();
    }

    @IgnoreEndpointModel
    @WebCmsAssetMapping(series={HttpStatus.Series.REDIRECTION})
    public RedirectView redirect(WebCmsUrl url, WebCmsAssetEndpoint endpoint) {
        return endpoint.getPrimaryUrl().map(primary -> {
            RedirectView result = new RedirectView(primary.getPath());
            result.setStatusCode(url.getHttpStatus());
            return result;
        }).orElseGet(() -> {
            RedirectView result = new RedirectView("/404");
            result.setStatusCode(HttpStatus.NOT_FOUND);
            return result;
        });
    }
}

