/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.web.thymeleaf.ThymeleafModelBuilder;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarker;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.web.thymeleaf.WebCmsComponentContentMarkerRenderer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
class ComponentContentMarkerRenderer
implements WebCmsComponentContentMarkerRenderer<WebCmsComponentModel> {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentContentMarkerRenderer.class);
    public static final String MARKER_KEY = "wcm:component";
    private final WebCmsComponentModelHierarchy componentModelHierarchy;

    @Override
    public boolean supports(WebCmsComponentModel componentModel, WebCmsContentMarker marker) {
        return marker.hasParameters() && MARKER_KEY.equals(marker.getKey());
    }

    @Override
    public void writeMarkerOutput(WebCmsComponentModel component, WebCmsContentMarker marker, ThymeleafModelBuilder model) {
        String[] parameters = marker.getParameterString().split(",");
        if (parameters.length == 3) {
            Optional.ofNullable(this.retrieveComponentModelToRender(component, parameters[0], parameters[1], Boolean.parseBoolean(parameters[2]))).ifPresent(arg_0 -> ((ThymeleafModelBuilder)model).addViewElement(arg_0));
        } else {
            LOG.error("Illegal wcm:component marker: {} - parameters could not be parsed, required parameters are (componentName,scope,searchParentScopes)", (Object)marker);
        }
    }

    private WebCmsComponentModel retrieveComponentModelToRender(WebCmsComponentModel parent, String componentName, String scopeName, boolean searchParentScopes) {
        WebCmsComponentModel componentToRender = null;
        if ("container".equals(scopeName)) {
            if (parent instanceof ContainerWebCmsComponentModel) {
                componentToRender = ((ContainerWebCmsComponentModel)parent).getMember(componentName);
            }
            if (componentToRender == null && searchParentScopes) {
                componentToRender = this.componentModelHierarchy.getFromScope(componentName, scopeName, true);
            }
        } else {
            componentToRender = this.componentModelHierarchy.getFromScope(componentName, scopeName, searchParentScopes);
        }
        return componentToRender;
    }

    public ComponentContentMarkerRenderer(WebCmsComponentModelHierarchy componentModelHierarchy) {
        this.componentModelHierarchy = componentModelHierarchy;
    }
}

