/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.component.QWebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.WebCmsAllowedComponentTypeFetcher;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentTypeRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Component;

@Order(value=0x7FFFFFFF)
@Component
public class DefaultAllowedComponentTypeFetcher
implements WebCmsAllowedComponentTypeFetcher {
    public static final String ALLOWED_COMPONENT_LINK = "allowed-component";
    private final WebCmsComponentTypeRepository componentTypeRepository;
    private final WebCmsDataConversionService dataConversionService;
    private final WebCmsTypeSpecifierLinkRepository typeLinkRepository;
    private final WebCmsMultiDomainService multiDomainService;

    @Override
    public boolean supports(WebCmsObject owner, WebCmsDomain domain) {
        return true;
    }

    @Override
    public List<WebCmsComponentType> fetchComponentTypes(WebCmsObject owner, WebCmsDomain domain) {
        WebCmsTypeSpecifier type;
        if (owner != null && (type = this.getType(owner)) != null && type.isChildComponentRestricted()) {
            return this.fetchLinkedTypes(type, domain);
        }
        return this.fetchAllTypes(domain);
    }

    private List<WebCmsComponentType> fetchLinkedTypes(WebCmsTypeSpecifier type, WebCmsDomain domain) {
        return this.typeLinkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(type.getObjectId(), ALLOWED_COMPONENT_LINK).stream().map(WebCmsTypeSpecifierLink::getTypeSpecifier).map(WebCmsComponentType.class::cast).collect(Collectors.toList());
    }

    private List<WebCmsComponentType> fetchAllTypes(WebCmsDomain domain) {
        WebCmsDomain domainToUse = domain;
        if (!this.multiDomainService.isDomainBound(WebCmsComponentType.class)) {
            domainToUse = WebCmsDomain.NONE;
        }
        QWebCmsComponentType query = QWebCmsComponentType.webCmsComponentType;
        return this.componentTypeRepository.findAll((Predicate)(domainToUse != null ? query.domain.eq(domain) : query.domain.isNull())).stream().filter(type -> {
            String attributeValue = type.getAttribute("componentRestricted");
            return attributeValue == null || (Boolean)this.dataConversionService.convert(attributeValue, TypeDescriptor.valueOf(Boolean.class)) == false;
        }).collect(Collectors.toList());
    }

    private WebCmsTypeSpecifier getType(WebCmsObject owner) {
        if (owner instanceof WebCmsAsset) {
            return ((WebCmsAsset)owner).getAssetType();
        }
        if (owner instanceof WebCmsComponent) {
            return ((WebCmsComponent)owner).getComponentType();
        }
        return null;
    }

    public DefaultAllowedComponentTypeFetcher(WebCmsComponentTypeRepository componentTypeRepository, WebCmsDataConversionService dataConversionService, WebCmsTypeSpecifierLinkRepository typeLinkRepository, WebCmsMultiDomainService multiDomainService) {
        this.componentTypeRepository = componentTypeRepository;
        this.dataConversionService = dataConversionService;
        this.typeLinkRepository = typeLinkRepository;
        this.multiDomainService = multiDomainService;
    }
}

