/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.WebCmsObjectSuperClass;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_component")
@Access(value=AccessType.FIELD)
@NotThreadSafe
public class WebCmsComponent
extends WebCmsObjectSuperClass<WebCmsComponent> {
    public static final String COLLECTION_ID = "wcm:component";
    @ManyToOne
    @JoinColumn(name="component_type_id")
    @NotNull
    WebCmsComponentType componentType;
    @Id
    @GeneratedValue(generator="seq_wcm_component_id")
    @GenericGenerator(name="seq_wcm_component_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_component_id"), @Parameter(name="allocationSize", value="5")})
    private Long id;
    @Column(name="owner_object_id")
    @Length(max=100)
    private @Length(max=100) String ownerObjectId;
    @Column(name="title")
    @NotBlank(groups={SharedComponentValidation.class})
    @Length(max=255)
    private @NotBlank(groups={SharedComponentValidation.class}) @Length(max=255) String title;
    @Column(name="name")
    @NotBlank(groups={SharedComponentValidation.class})
    @Pattern(regexp="^[\\p{Alnum}-_.]*$")
    @Length(max=100)
    private @NotBlank(groups={SharedComponentValidation.class}) @Pattern(regexp="^[\\p{Alnum}-_.]*$") @Length(max=100) String name;
    @Column(name="sort_index")
    private int sortIndex;
    @Column(name="body")
    private String body;
    @Column(name="metadata")
    private String metadata;
    @Column(name="body_contains_markers")
    private boolean bodyWithContentMarkers;
    @ManyToOne
    @JoinColumn(name="proxied_component_id")
    private WebCmsComponent proxyTarget;

    public WebCmsComponent() {
    }

    public WebCmsComponent(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, WebCmsComponentType componentType, String ownerObjectId, String name, int sortIndex, String title, String body, String metadata, WebCmsComponent proxyTarget) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain);
        this.componentType = componentType;
        this.ownerObjectId = ownerObjectId;
        this.name = name;
        this.sortIndex = sortIndex;
        this.title = title;
        this.body = body;
        this.metadata = metadata;
        this.proxyTarget = proxyTarget;
    }

    public void setOwner(WebCmsObject owner) {
        this.setOwnerObjectId(owner != null ? owner.getObjectId() : null);
    }

    public boolean hasOwner() {
        return this.getOwnerObjectId() != null;
    }

    public boolean isProxyComponent() {
        return this.getProxyTarget() != null;
    }

    @Override
    protected String getObjectCollectionId() {
        return COLLECTION_ID;
    }

    public WebCmsComponent asTemplate() {
        WebCmsComponent template = new WebCmsComponent();
        template.componentType = this.componentType;
        template.title = this.title;
        template.name = this.name;
        template.body = this.body;
        template.metadata = this.metadata;
        template.sortIndex = this.sortIndex;
        template.proxyTarget = this.proxyTarget;
        template.setDomain(this.getDomain());
        return template;
    }

    public String toString() {
        return "WebCmsComponent{objectId='" + this.getObjectId() + "',componentType=" + this.componentType + '}';
    }

    public static WebCmsComponentBuilder builder() {
        return new WebCmsComponentBuilder();
    }

    public WebCmsComponentBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        WebCmsDomain domain = this.getDomain();
        return new WebCmsComponentBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).domain(domain).componentType(this.componentType).ownerObjectId(this.ownerObjectId).name(this.name).sortIndex(this.sortIndex).title(this.title).body(this.body).metadata(this.metadata).proxyTarget(this.proxyTarget);
    }

    public WebCmsComponentType getComponentType() {
        return this.componentType;
    }

    public Long getId() {
        return this.id;
    }

    public String getOwnerObjectId() {
        return this.ownerObjectId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public String getBody() {
        return this.body;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public WebCmsComponent getProxyTarget() {
        return this.proxyTarget;
    }

    public void setComponentType(WebCmsComponentType componentType) {
        this.componentType = componentType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOwnerObjectId(String ownerObjectId) {
        this.ownerObjectId = ownerObjectId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setProxyTarget(WebCmsComponent proxyTarget) {
        this.proxyTarget = proxyTarget;
    }

    public boolean isBodyWithContentMarkers() {
        return this.bodyWithContentMarkers;
    }

    protected void setBodyWithContentMarkers(boolean bodyWithContentMarkers) {
        this.bodyWithContentMarkers = bodyWithContentMarkers;
    }

    public static class WebCmsComponentBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private WebCmsDomain domain;
        private WebCmsComponentType componentType;
        private String ownerObjectId;
        private String name;
        private int sortIndex;
        private String title;
        private String body;
        private String metadata;
        private WebCmsComponent proxyTarget;

        WebCmsComponentBuilder() {
        }

        public WebCmsComponentBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsComponentBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsComponentBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsComponentBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsComponentBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsComponentBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsComponentBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsComponentBuilder domain(WebCmsDomain domain) {
            this.domain = domain;
            return this;
        }

        public WebCmsComponentBuilder componentType(WebCmsComponentType componentType) {
            this.componentType = componentType;
            return this;
        }

        public WebCmsComponentBuilder ownerObjectId(String ownerObjectId) {
            this.ownerObjectId = ownerObjectId;
            return this;
        }

        public WebCmsComponentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WebCmsComponentBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsComponentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WebCmsComponentBuilder body(String body) {
            this.body = body;
            return this;
        }

        public WebCmsComponentBuilder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public WebCmsComponentBuilder proxyTarget(WebCmsComponent proxyTarget) {
            this.proxyTarget = proxyTarget;
            return this;
        }

        public WebCmsComponent build() {
            return new WebCmsComponent(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.domain, this.componentType, this.ownerObjectId, this.name, this.sortIndex, this.title, this.body, this.metadata, this.proxyTarget);
        }

        public String toString() {
            return "WebCmsComponent.WebCmsComponentBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", domain=" + this.domain + ", componentType=" + this.componentType + ", ownerObjectId=" + this.ownerObjectId + ", name=" + this.name + ", sortIndex=" + this.sortIndex + ", title=" + this.title + ", body=" + this.body + ", metadata=" + this.metadata + ", proxyTarget=" + this.proxyTarget + ")";
        }
    }

    public static interface SharedComponentValidation {
    }
}

