/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.entity.util.EntityUtils;
import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentValidator;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
@Scope(value="prototype")
public class WebCmsComponentImporter
extends AbstractWebCmsDataImporter<WebCmsComponentModel, WebCmsComponentModel> {
    private final String dataKey = "component";
    private WebCmsComponentRepository componentRepository;
    private WebCmsComponentModelService componentModelService;
    private WebCmsComponentValidator componentValidator;
    private WebCmsDataConversionService conversionService;
    private WebCmsObject owner;

    @Override
    public final boolean supports(WebCmsDataEntry data) {
        return "assets".equals(data.getParent().getParentKey()) && "component".equals(data.getParentKey());
    }

    @Override
    protected WebCmsComponentModel retrieveExistingInstance(WebCmsDataEntry data) {
        String objectId = (String)data.getMapData().get("objectId");
        String entryKey = StringUtils.defaultString((String)data.getKey(), (String)((String)data.getMapData().get("name")));
        WebCmsComponentModel existing = null;
        if (objectId != null) {
            existing = this.componentModelService.getComponentModel(objectId);
        }
        WebCmsDomain domain = this.owner != null && (this.owner instanceof WebCmsComponent || this.owner instanceof WebCmsComponentModel) ? ((WebCmsDomainBound)((Object)this.owner)).getDomain() : this.retrieveDomainForDataEntry(data, WebCmsComponent.class);
        if (existing == null && entryKey != null) {
            existing = this.componentModelService.getComponentModelByNameAndDomain(entryKey, WebCmsObject.forObjectId(this.getOwnerObjectId()), domain);
        }
        return existing;
    }

    @Override
    protected WebCmsComponentModel createDto(WebCmsDataEntry data, WebCmsComponentModel itemToUpdate, WebCmsDataAction action, Map<String, Object> dataValues) {
        if (itemToUpdate == null) {
            WebCmsComponentModel componentModel = this.componentModelService.createComponentModel((WebCmsComponentType)this.conversionService.convert(dataValues.get("componentType"), WebCmsComponentType.class), WebCmsComponentModel.class);
            componentModel.setName(data.getKey());
            componentModel.setOwnerObjectId(this.getOwnerObjectId());
            return componentModel;
        }
        String requestedComponentType = (String)dataValues.get("componentType");
        if (requestedComponentType != null && !requestedComponentType.equals(itemToUpdate.getComponentType().getTypeKey()) || WebCmsDataAction.REPLACE.equals((Object)action)) {
            this.LOG.trace("Changing component type: from {} to {} - resetting object", (Object)itemToUpdate.getComponentType().getTypeKey(), (Object)requestedComponentType);
            WebCmsComponentModel dto = this.componentModelService.createComponentModel(requestedComponentType, WebCmsComponentModel.class);
            WebCmsComponent newComponent = dto.getComponent();
            WebCmsComponent existing = itemToUpdate.getComponent();
            newComponent.setId(existing.getId());
            newComponent.setOwnerObjectId(existing.getOwnerObjectId());
            newComponent.setTitle(existing.getTitle());
            newComponent.setName(existing.getName());
            newComponent.setSortIndex(existing.getSortIndex());
            newComponent.setCreatedBy(existing.getCreatedBy());
            newComponent.setCreatedDate(existing.getCreatedDate());
            newComponent.setDomain(existing.getDomain());
            this.addForceUpdateProperty(dataValues);
            return dto;
        }
        return itemToUpdate;
    }

    @Override
    protected void deleteInstance(WebCmsComponentModel instance, WebCmsDataEntry data) {
        this.LOG.trace("WebCmsComponent {} with objectId {}: removing component", (Object)"component", (Object)instance.getObjectId());
        this.componentRepository.delete(instance.getComponent());
    }

    @Override
    protected WebCmsComponentModel prepareForSaving(WebCmsComponentModel itemToBeSaved, WebCmsDataEntry data) {
        if (itemToBeSaved.getName() == null) {
            itemToBeSaved.setName(data.getKey());
        }
        if (!StringUtils.isBlank((CharSequence)itemToBeSaved.getName()) && StringUtils.isEmpty((CharSequence)itemToBeSaved.getComponent().getTitle())) {
            itemToBeSaved.setTitle(EntityUtils.generateDisplayName((String)itemToBeSaved.getName()));
        }
        return itemToBeSaved;
    }

    @Override
    protected void saveDto(WebCmsComponentModel itemToSave, WebCmsDataAction action, WebCmsDataEntry data) {
        this.LOG.debug("Saving WebCmsComponent {} with objectId {} (insert: {}) - {}", new Object[]{"component", itemToSave.getObjectId(), itemToSave.isNew(), itemToSave});
        this.componentModelService.save(itemToSave);
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsComponentModel dto) {
        HashMap<String, Object> mapData = new HashMap<String, Object>(values);
        mapData.remove("componentType");
        return super.applyDataValues(mapData, dto);
    }

    private String getOwnerObjectId() {
        return this.owner != null ? this.owner.getObjectId() : null;
    }

    public void setOwner(WebCmsObject owner) {
        this.owner = owner;
    }

    @Override
    protected void validate(WebCmsComponentModel itemToBeSaved, Errors errors) {
        this.componentValidator.validate(itemToBeSaved.getComponent(), errors);
    }

    @Autowired
    void setComponentModelService(WebCmsComponentModelService componentModelService) {
        this.componentModelService = componentModelService;
    }

    @Autowired
    void setComponentRepository(WebCmsComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }

    @Autowired
    void setComponentValidator(WebCmsComponentValidator componentValidator) {
        this.componentValidator = componentValidator;
    }

    @Autowired
    void setConversionService(WebCmsDataConversionService conversionService) {
        this.conversionService = conversionService;
    }
}

