/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarkerService;
import org.springframework.stereotype.Component;

@Component
class WebCmsComponentInterceptor
extends EntityInterceptorAdapter<WebCmsComponent> {
    private final WebCmsContentMarkerService contentMarkerService;

    public boolean handles(Class<?> aClass) {
        return WebCmsComponent.class.isAssignableFrom(aClass);
    }

    public void beforeCreate(WebCmsComponent component) {
        this.updateBodyContainsMarkers(component);
    }

    public void beforeUpdate(WebCmsComponent component) {
        this.updateBodyContainsMarkers(component);
    }

    private void updateBodyContainsMarkers(WebCmsComponent component) {
        if (this.contentMarkerService.containsMarkers(component.getBody())) {
            component.setBodyWithContentMarkers(true);
        }
    }

    public WebCmsComponentInterceptor(WebCmsContentMarkerService contentMarkerService) {
        this.contentMarkerService = contentMarkerService;
    }
}

