/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.entity.util.EntityUtils;
import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsComponentValidator
extends EntityValidatorSupport<WebCmsComponent> {
    private final WebCmsComponentRepository componentRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsComponent.class.isAssignableFrom(clazz);
    }

    protected void preValidation(WebCmsComponent entity, Errors errors, Object ... validationHints) {
        if (StringUtils.isBlank((CharSequence)entity.getName()) && !StringUtils.isBlank((CharSequence)entity.getTitle())) {
            entity.setName(WebCmsUtils.generateUrlPathSegment(entity.getTitle()));
        } else if (!StringUtils.isBlank((CharSequence)entity.getName()) && StringUtils.isBlank((CharSequence)entity.getTitle())) {
            entity.setTitle(EntityUtils.generateDisplayName((String)entity.getName()));
        }
    }

    protected void postValidation(WebCmsComponent entity, Errors errors, Object ... validationHints) {
        if (!(errors.hasFieldErrors("name") || entity.hasOwner() && StringUtils.isEmpty((CharSequence)entity.getName()))) {
            this.componentRepository.findOneByOwnerObjectIdAndNameAndDomain(entity.getOwnerObjectId(), entity.getName(), entity.getDomain()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("name", "alreadyExists"));
        }
    }

    public WebCmsComponentValidator(WebCmsComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }
}

