/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public final class WebCmsContentMarker {
    private final String key;
    private final String parameterString;

    public WebCmsContentMarker(String key) {
        this(key, null);
    }

    public WebCmsContentMarker(String key, String parameterString) {
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)key), (String)"Marker key must not be blank");
        Assert.isTrue((!StringUtils.containsWhitespace((CharSequence)key) ? 1 : 0) != 0, (String)"Marker key should not contain whitespace");
        this.key = key;
        this.parameterString = parameterString;
    }

    public boolean hasParameters() {
        return this.parameterString != null;
    }

    public String toString() {
        return "@@" + this.key + (this.hasParameters() ? "(" + this.parameterString + ")" : "") + "@@";
    }

    public static WebCmsContentMarker fromMarkerString(String marker) {
        if (marker.startsWith("@@")) {
            return WebCmsContentMarker.parseWithoutBoundaries(marker.substring(2, marker.length() - 2));
        }
        return WebCmsContentMarker.parseWithoutBoundaries(marker);
    }

    private static WebCmsContentMarker parseWithoutBoundaries(String marker) {
        if (marker.endsWith(")")) {
            int startOfParameters = marker.indexOf(40);
            return new WebCmsContentMarker(marker.substring(0, startOfParameters), marker.substring(startOfParameters + 1, marker.lastIndexOf(41)));
        }
        return new WebCmsContentMarker(marker);
    }

    public String getKey() {
        return this.key;
    }

    public String getParameterString() {
        return this.parameterString;
    }
}

