/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component;

import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WebCmsContentMarkerService {
    public static Pattern MARKER_PATTERN = Pattern.compile("@@[^\\s]+?(\\(.*?\\))?@@");

    public WebCmsContentMarker parseMarker(String marker) {
        return WebCmsContentMarker.fromMarkerString(marker);
    }

    public boolean containsMarkers(String text) {
        return !this.retrieveMarkers(text).isEmpty();
    }

    public Collection<String> retrieveMarkers(String text) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            ArrayList<String> markers = new ArrayList<String>();
            Matcher matcher = MARKER_PATTERN.matcher(text);
            while (matcher.find()) {
                markers.add(matcher.group());
            }
            return markers;
        }
        return Collections.emptyList();
    }

    public String replaceMarkers(String text, Map<String, String> markerValues) {
        return this.replaceMarkers(text, (WebCmsContentMarker marker) -> (String)markerValues.get(marker.toString()));
    }

    public String stripMarkers(String text) {
        return this.replaceMarkers(text, (WebCmsContentMarker marker) -> "");
    }

    public String replaceMarkers(String text, @NonNull Function<WebCmsContentMarker, String> markerValueFunction) {
        if (markerValueFunction == null) {
            throw new NullPointerException("markerValueFunction is marked non-null but is null");
        }
        if (!StringUtils.isEmpty((CharSequence)text)) {
            StringBuilder stringBuilder = new StringBuilder(text.length());
            Matcher matcher = MARKER_PATTERN.matcher(text);
            int start = 0;
            while (matcher.find()) {
                stringBuilder.append(text.substring(start, matcher.start()));
                stringBuilder.append(StringUtils.defaultString((String)markerValueFunction.apply(this.parseMarker(matcher.group())), (String)matcher.group()));
                start = matcher.end();
            }
            stringBuilder.append(text.substring(start));
            return stringBuilder.toString();
        }
        return text;
    }
}

