/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.config;

import com.foreach.across.modules.bootstrapui.elements.Grid;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.bootstrapui.options.OptionIterableBuilder;
import com.foreach.across.modules.entity.views.processors.DefaultValidationViewProcessor;
import com.foreach.across.modules.entity.views.processors.ListFormViewProcessor;
import com.foreach.across.modules.entity.views.processors.SaveEntityViewProcessor;
import com.foreach.across.modules.entity.views.processors.SingleEntityFormViewProcessor;
import com.foreach.across.modules.entity.views.processors.SingleEntityPageStructureViewProcessor;
import com.foreach.across.modules.entity.views.processors.SortableTableRenderingViewProcessor;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.placeholder.PlaceholderWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.text.TextWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.web.ComponentTypeOptionIterableBuilder;
import com.foreach.across.modules.webcms.domain.component.web.ContainerMemberViewProcessor;
import com.foreach.across.modules.webcms.domain.component.web.SearchComponentViewProcessor;
import com.foreach.across.modules.webcms.domain.component.web.SingleWebCmsComponentFormProcessor;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.foreach.across.modules.webcms.domain.image.component.ImageWebCmsComponentModel;
import javax.validation.groups.Default;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
class WebCmsComponentConfiguration {
    WebCmsComponentConfiguration() {
    }

    @Autowired
    void registerSingleValuePropertyConverters(WebCmsDataConversionService conversionService) {
        conversionService.registerSingleValueProperty(TextWebCmsComponentModel.class, "content");
        conversionService.registerSingleValueProperty(ImageWebCmsComponentModel.class, "image");
    }

    @ConditionalOnAdminUI
    @Configuration
    static class AdminUiConfiguration
    implements EntityConfigurer {
        private final ContainerMemberViewProcessor containerMemberViewProcessor;
        private final SingleWebCmsComponentFormProcessor formProcessor;
        private final SearchComponentViewProcessor searchComponentViewProcessor;
        private final WebCmsComponentModelService componentModelService;
        private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
        private final ComponentTypeOptionIterableBuilder componentTypeOptionIterableBuilder;

        public void configure(EntitiesConfigurationBuilder entities) {
            entities.create().entityType(PlaceholderWebCmsComponentModel.Metadata.class, true);
            entities.withType(WebCmsComponentType.class).properties(props -> props.property("name").order(0).and().property("typeKey").order(1).and().property("description").order(2)).hide().updateFormView(fvb -> fvb.showProperties(new String[]{"name", "typeKey", "description", "created", "lastModified"}));
            String domainFilterEql = this.multiDomainConfiguration.isDomainBound(WebCmsComponent.class) ? " and domain = selectedDomain()" : "";
            entities.withType(WebCmsComponent.class).entityModel(modelBuilder -> modelBuilder.saveMethod(this.componentModelService::save)).properties(props -> props.property("componentType").order(0).attribute(OptionIterableBuilder.class, (Object)this.componentTypeOptionIterableBuilder).and().property("title").order(1).and().property("name").order(2).and().property("ownerObjectId").hidden(true).and().property("sortIndex").order(10).hidden(true).and().property("objectId").writable(false).hidden(true).and().property("body").hidden(true).and().property("metadata").hidden(true).and().property("bodyWithContentMarkers").hidden(true).and().property("proxyTarget").hidden(true)).attribute(SearchComponentViewProcessor.COMPONENT_SEARCH_QUERY, (Object)("((title like '%{0}%' or name like '%{0}') and ownerObjectId is NULL)" + domainFilterEql)).attribute("webCmsModule.multiDomain.configuration.listViewAdjusted", (Object)true).listView(lvb -> lvb.entityQueryFilter(true).entityQueryPredicate("(ownerObjectId is NULL)" + domainFilterEql).showProperties(new String[]{"title", "name", "componentType", "lastModified"}).defaultSort("title")).createFormView(fvb -> fvb.messagePrefix(new String[]{"views[createShared]", "views[createView]"}).postProcess(DefaultValidationViewProcessor.class, processor -> processor.setValidationHints(new Object[]{Default.class, WebCmsComponent.SharedComponentValidation.class}))).formView("createMember", fvb -> fvb.messagePrefix(new String[]{"views[createMember]", "views[updateView]"}).viewProcessor((EntityViewProcessor)this.containerMemberViewProcessor).postProcess(SingleEntityPageStructureViewProcessor.class, processor -> processor.setTitleMessageCode("pageTitle.create"))).deleteFormView(fvb -> fvb.viewProcessor((EntityViewProcessor)this.containerMemberViewProcessor)).updateFormView(fvb -> fvb.showProperties(new String[0]).viewProcessor((EntityViewProcessor)this.formProcessor).removeViewProcessor(SaveEntityViewProcessor.class.getName()).removeViewProcessor(DefaultValidationViewProcessor.class.getName()).postProcess(SingleEntityFormViewProcessor.class, processor -> processor.setGrid(Grid.create((int[])new int[]{12})))).listView("search", lvb -> lvb.showProperties(new String[]{"title", "name", "componentType", "lastModified"}).sortableOn(new String[0]).showResultNumber(false).postProcess(ListFormViewProcessor.class, p -> p.setAddDefaultButtons(false)).postProcess(SortableTableRenderingViewProcessor.class, p -> p.setIncludeDefaultActions(false)).viewProcessor((EntityViewProcessor)this.searchComponentViewProcessor)).association(ab -> ab.name("webCmsComponent.proxyTarget").hide());
        }

        public AdminUiConfiguration(ContainerMemberViewProcessor containerMemberViewProcessor, SingleWebCmsComponentFormProcessor formProcessor, SearchComponentViewProcessor searchComponentViewProcessor, WebCmsComponentModelService componentModelService, WebCmsMultiDomainConfiguration multiDomainConfiguration, ComponentTypeOptionIterableBuilder componentTypeOptionIterableBuilder) {
            this.containerMemberViewProcessor = containerMemberViewProcessor;
            this.formProcessor = formProcessor;
            this.searchComponentViewProcessor = searchComponentViewProcessor;
            this.componentModelService = componentModelService;
            this.multiDomainConfiguration = multiDomainConfiguration;
            this.componentTypeOptionIterableBuilder = componentTypeOptionIterableBuilder;
        }
    }
}

