/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.config;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.bootstrapui.elements.Grid;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntityConfigurationBuilder;
import com.foreach.across.modules.entity.query.AssociatedEntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQueryCondition;
import com.foreach.across.modules.entity.query.EntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQueryOps;
import com.foreach.across.modules.entity.registry.EntityAssociation;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.processors.DefaultValidationViewProcessor;
import com.foreach.across.modules.entity.views.processors.SingleEntityFormViewProcessor;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.web.SingleWebCmsComponentFormProcessor;
import java.util.HashSet;
import java.util.Set;
import javax.validation.groups.Default;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;

@ConditionalOnAdminUI
@Exposed
@Configuration
public class WebCmsObjectComponentViewsConfiguration {
    private final SingleWebCmsComponentFormProcessor formProcessor;
    private final Set<Class<?>> assetTypes = new HashSet();
    private final EntityRegistry entityRegistry;

    public void enable(Class<? extends WebCmsObject> assetType) {
        this.assetTypes.add(assetType);
    }

    public void disable(Class<? extends WebCmsObject> assetType) {
        this.assetTypes.remove(assetType);
    }

    public void registerComponentsAssociation(EntityConfigurationBuilder<?> configuration) {
        configuration.association(ab -> ab.name("webCmsComponents").targetEntityType(WebCmsComponent.class).targetProperty("owner").associationType(EntityAssociation.Type.EMBEDDED).parentDeleteMode(EntityAssociation.ParentDeleteMode.WARN).listView(lvb -> lvb.showProperties(new String[]{"title", "name", "componentType", "lastModified"}).defaultSort(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"sortIndex", "title"}))).createFormView(fvb -> fvb.postProcess(DefaultValidationViewProcessor.class, viewProcessor -> viewProcessor.setValidationHints(new Object[]{Default.class, WebCmsComponent.SharedComponentValidation.class}))).updateFormView(fvb -> fvb.properties(props -> props.property("componentType").writable(false)).showProperties(new String[0]).viewProcessor((EntityViewProcessor)this.formProcessor).postProcess(SingleEntityFormViewProcessor.class, processor -> processor.setGrid(Grid.create((int[])new int[]{12})))).deleteFormView()).postProcessor(cfg -> cfg.association("webCmsComponents").setAttribute(AssociatedEntityQueryExecutor.class, this.createExecutorForWebCmsObject()));
    }

    private AssociatedEntityQueryExecutor<WebCmsComponent> createExecutorForWebCmsObject() {
        EntityConfiguration entityConfiguration = this.entityRegistry.getEntityConfiguration(WebCmsComponent.class);
        EntityQueryExecutor entityQueryExecutor = (EntityQueryExecutor)entityConfiguration.getAttribute(EntityQueryExecutor.class);
        return new AssociatedEntityQueryExecutor<WebCmsComponent>(null, entityQueryExecutor){

            protected EntityQueryCondition buildEqualsOrContainsCondition(Object value) {
                return new EntityQueryCondition("ownerObjectId", EntityQueryOps.EQ, new Object[]{((WebCmsObject)value).getObjectId()});
            }
        };
    }

    @Bean
    EntityConfigurer webCmsComponentsAssociationConfigurer() {
        return entities -> this.registerComponentsAssociation(entities.matching(config -> WebCmsObject.class.isAssignableFrom(config.getEntityType()) && this.assetTypes.contains(config.getEntityType())));
    }

    public WebCmsObjectComponentViewsConfiguration(SingleWebCmsComponentFormProcessor formProcessor, EntityRegistry entityRegistry) {
        this.formProcessor = formProcessor;
        this.entityRegistry = entityRegistry;
    }
}

