/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.container;

import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarker;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateService;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateStrategy;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import com.foreach.across.modules.webcms.domain.component.placeholder.PlaceholderWebCmsComponentModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=0x7FFFFFFE)
class ContainerWebCmsComponentAutoCreateStrategy
implements WebCmsComponentAutoCreateStrategy<ContainerWebCmsComponentModel> {
    ContainerWebCmsComponentAutoCreateStrategy() {
    }

    @Override
    public boolean supports(WebCmsComponentModel componentModel, WebCmsComponentAutoCreateTask task) {
        return componentModel instanceof ContainerWebCmsComponentModel;
    }

    @Override
    public void buildComponentModel(WebCmsComponentAutoCreateService autoCreateService, ContainerWebCmsComponentModel componentModel, WebCmsComponentAutoCreateTask task) {
        String markup = StringUtils.trimToEmpty((String)task.getOutput());
        task.getChildren().forEach(childTask -> {
            WebCmsComponentModel member = autoCreateService.buildComponent((WebCmsComponentAutoCreateTask)childTask);
            if (member != null) {
                member.setOwner(componentModel);
                componentModel.addMember(member);
            }
        });
        markup = this.replacePlaceholdersByComponents(componentModel, markup);
        componentModel.setMarkup(markup);
    }

    private String replacePlaceholdersByComponents(ContainerWebCmsComponentModel componentModel, String originalMarkup) {
        String markup = originalMarkup;
        for (WebCmsComponentModel member : componentModel.getMembers()) {
            if (!(member instanceof PlaceholderWebCmsComponentModel)) continue;
            PlaceholderWebCmsComponentModel placeholderComponent = (PlaceholderWebCmsComponentModel)member;
            WebCmsContentMarker contentMarker = new WebCmsContentMarker("wcm:placeholder", placeholderComponent.getPlaceholderName());
            WebCmsContentMarker componentMarker = new WebCmsContentMarker("wcm:component", member.getName() + ",container,false");
            markup = StringUtils.replace((String)markup, (String)contentMarker.toString(), (String)componentMarker.toString());
        }
        return markup;
    }
}

