/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.container;

import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class ContainerWebCmsComponentModel
extends WebCmsComponentModel {
    public static final String TYPE_DYNAMIC = "container";
    public static final String TYPE_FIXED = "fixed-container";
    public static final String SUPPORTS_MARKUP_ATTRIBUTE = "supportsMarkup";
    private String markup;
    private final List<WebCmsComponentModel> members = new ArrayList<WebCmsComponentModel>();

    public ContainerWebCmsComponentModel(WebCmsComponentType containerType) {
        super(containerType);
    }

    public ContainerWebCmsComponentModel(WebCmsComponent component, Collection<WebCmsComponentModel> components) {
        this(component);
        this.members.addAll(components);
    }

    public ContainerWebCmsComponentModel(WebCmsComponent component) {
        super(component);
        this.markup = component.getBody();
    }

    protected ContainerWebCmsComponentModel(WebCmsComponentModel template) {
        super(template);
    }

    public void addMember(WebCmsComponentModel componentModel) {
        this.members.add(componentModel);
    }

    public <U extends WebCmsComponentModel> U getMember(String name, @NonNull Class<U> expectedType) {
        if (expectedType == null) {
            throw new NullPointerException("expectedType is marked non-null but is null");
        }
        return (U)((WebCmsComponentModel)expectedType.cast(this.getMember(name)));
    }

    public WebCmsComponentModel getMember(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        for (WebCmsComponentModel member : this.members) {
            if (!name.equals(member.getName())) continue;
            return member;
        }
        return null;
    }

    public int size() {
        return this.members.size();
    }

    @Override
    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public boolean isFixed() {
        return TYPE_FIXED.equals(this.getComponentType().getAttribute("type"));
    }

    public boolean hasMarkup() {
        return StringUtils.isNotEmpty((CharSequence)this.markup);
    }

    public boolean isMarkupSupported() {
        return StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)this.getComponentType().getAttribute(SUPPORTS_MARKUP_ATTRIBUTE));
    }

    @Override
    public ContainerWebCmsComponentModel asComponentTemplate() {
        ContainerWebCmsComponentModel template = new ContainerWebCmsComponentModel(this);
        template.markup = this.markup;
        this.members.forEach(member -> template.addMember(member.asComponentTemplate()));
        return template;
    }

    public String getMarkup() {
        return this.markup;
    }

    public void setMarkup(String markup) {
        this.markup = markup;
    }

    public List<WebCmsComponentModel> getMembers() {
        return this.members;
    }
}

