/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.container;

import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.AbstractWebCmsComponentModelWriter;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.text.TextWebCmsComponentModel;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ContainerWebCmsComponentModelWriter
extends AbstractWebCmsComponentModelWriter<ContainerWebCmsComponentModel> {
    private final WebCmsComponentModelService webCmsComponentModelService;
    private final WebCmsComponentRepository webCmsComponentRepository;

    @Override
    public boolean supports(WebCmsComponentModel componentModel) {
        return ContainerWebCmsComponentModel.class.isInstance(componentModel);
    }

    @Override
    protected void buildMainComponent(ContainerWebCmsComponentModel componentModel, WebCmsComponent component) {
        component.setBody(componentModel.getMarkup());
    }

    @Override
    protected void beforeUpdate(ContainerWebCmsComponentModel componentModel) {
    }

    @Override
    protected void afterUpdate(ContainerWebCmsComponentModel componentModel, WebCmsComponent mainComponent) {
        List<WebCmsComponentModel> members = componentModel.getMembers();
        members.sort(Comparator.comparingInt(m -> m.getComponent().getSortIndex()));
        members.forEach(m -> this.replaceAttributesInTextComponents(componentModel, (WebCmsComponentModel)m));
        Map modelsByObjectId = this.webCmsComponentModelService.getComponentModelsForOwner(componentModel, componentModel.getDomain()).stream().collect(Collectors.toMap(WebCmsComponentModel::getObjectId, Function.identity()));
        for (int i = 0; i < members.size(); ++i) {
            WebCmsComponentModel member = members.get(i);
            member.setSortIndex(i + 1);
            member.setOwner(componentModel);
            member.setDomain(componentModel.getDomain());
            this.webCmsComponentModelService.save(member);
            modelsByObjectId.remove(member.getObjectId());
        }
        modelsByObjectId.values().stream().map(WebCmsComponentModel::getComponent).forEach(arg_0 -> ((WebCmsComponentRepository)this.webCmsComponentRepository).delete(arg_0));
    }

    private void replaceAttributesInTextComponents(WebCmsComponentModel container, WebCmsComponentModel componentModel) {
        if (componentModel.isNew()) {
            if (componentModel instanceof TextWebCmsComponentModel) {
                TextWebCmsComponentModel text = (TextWebCmsComponentModel)componentModel;
                text.setContent(StringUtils.replace((String)text.getContent(), (String)"@@container.title@@", (String)container.getTitle()));
                text.setContent(StringUtils.replace((String)text.getContent(), (String)"@@container.name@@", (String)container.getName()));
            } else if (componentModel instanceof ContainerWebCmsComponentModel) {
                ((ContainerWebCmsComponentModel)componentModel).getMembers().forEach(m -> this.replaceAttributesInTextComponents(componentModel, (WebCmsComponentModel)m));
            }
        }
    }

    public ContainerWebCmsComponentModelWriter(WebCmsComponentModelService webCmsComponentModelService, WebCmsComponentRepository webCmsComponentRepository) {
        this.webCmsComponentModelService = webCmsComponentModelService;
        this.webCmsComponentRepository = webCmsComponentRepository;
    }
}

