/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.modules.webcms.data.json.WebCmsDataObjectMapper;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelReader;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

public abstract class AbstractWebCmsComponentModelReader<T extends WebCmsComponentModel>
implements WebCmsComponentModelReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebCmsComponentModelReader.class);
    private static final String TEMPLATE_COMPONENT = "componentTemplate";
    private WebCmsDataObjectMapper dataObjectMapper;
    private AutowireCapableBeanFactory beanFactory;
    private WebCmsComponentModelService componentModelService;

    @Override
    public final T readFromComponent(WebCmsComponent component) {
        T model = this.createComponentModel(component);
        if (model != null) {
            ((WebCmsComponentModel)model).setMetadata(this.buildMetadata(((WebCmsComponentModel)model).getMetadata(), component));
        }
        return model;
    }

    private T createComponentModel(WebCmsComponent component) {
        if (component.isNew()) {
            WebCmsDomain componentDomain = component.getDomain();
            WebCmsDomain componentTypeDomain = component.getComponentType().getDomain();
            WebCmsComponentModel template = this.componentModelService.getComponentModelByNameAndDomain(TEMPLATE_COMPONENT, component.getComponentType(), componentDomain);
            if (template == null && !Objects.equals(componentDomain, componentTypeDomain)) {
                template = this.componentModelService.getComponentModelByNameAndDomain(TEMPLATE_COMPONENT, component.getComponentType(), componentTypeDomain);
            }
            if (template != null) {
                WebCmsComponentModel model = template.asComponentTemplate();
                model.setComponent(component);
                return (T)model;
            }
        }
        return this.buildComponentModel(component);
    }

    protected Object buildMetadata(Object currentMetadata, WebCmsComponent component) {
        boolean componentHasMetadata = !StringUtils.isEmpty((CharSequence)component.getMetadata());
        String metadataClassName = component.getComponentType().getAttribute("metadata");
        Object metadata = currentMetadata;
        if (metadataClassName != null) {
            try {
                Class<?> metadataType = Class.forName(metadataClassName, true, Thread.currentThread().getContextClassLoader());
                if (currentMetadata == null || !metadataType.isInstance(currentMetadata)) {
                    metadata = this.beanFactory.createBean(metadataType);
                }
            }
            catch (Exception e) {
                LOG.error("Exception creating metadata {} for component {}.  Possibly the class is not present, not public or does not have a parameter-less constructor?", new Object[]{metadataClassName, component, e});
            }
        }
        if (componentHasMetadata && !this.dataObjectMapper.updateFromString(component.getMetadata(), metadata, false)) {
            LOG.warn("An exception occurred reading back metadata for component {}.  The actual metadata might not be complete: {}", (Object)component, metadata);
        }
        return metadata;
    }

    protected abstract T buildComponentModel(WebCmsComponent var1);

    @Autowired
    void setDataObjectMapper(WebCmsDataObjectMapper dataObjectMapper) {
        this.dataObjectMapper = dataObjectMapper;
    }

    @Autowired
    void setBeanFactory(AutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Autowired
    void setComponentModelService(WebCmsComponentModelService componentModelService) {
        this.componentModelService = componentModelService;
    }
}

