/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.modules.webcms.data.json.WebCmsDataObjectMapper;
import com.foreach.across.modules.webcms.domain.component.QWebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelWriter;
import com.querydsl.core.types.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractWebCmsComponentModelWriter<T extends WebCmsComponentModel>
implements WebCmsComponentModelWriter<T> {
    private WebCmsComponentRepository componentRepository;
    private WebCmsDataObjectMapper dataObjectMapper;

    @Override
    @Transactional
    public final WebCmsComponent save(T componentModel) {
        this.beforeUpdate(componentModel);
        WebCmsComponent mainComponent = ((WebCmsComponentModel)componentModel).getComponent();
        this.buildMainComponent(componentModel, mainComponent);
        this.writeMetadata(componentModel, mainComponent);
        mainComponent = this.saveComponent(mainComponent);
        this.afterUpdate(componentModel, mainComponent);
        return mainComponent;
    }

    protected WebCmsComponent saveComponent(WebCmsComponent component) {
        return (WebCmsComponent)this.componentRepository.save(component);
    }

    protected void beforeUpdate(T componentModel) {
        this.removeOwnedComponents(componentModel);
    }

    private void removeOwnedComponents(T componentModel) {
        if (!((WebCmsComponentModel)componentModel).isNew()) {
            this.componentRepository.findAll((Predicate)QWebCmsComponent.webCmsComponent.ownerObjectId.eq((Object)((WebCmsComponentModel)componentModel).getObjectId())).forEach(arg_0 -> ((WebCmsComponentRepository)this.componentRepository).delete(arg_0));
        }
    }

    protected abstract void buildMainComponent(T var1, WebCmsComponent var2);

    protected void writeMetadata(T componentModel, WebCmsComponent component) {
        component.setMetadata(((WebCmsComponentModel)componentModel).hasMetadata() ? this.dataObjectMapper.writeToString(((WebCmsComponentModel)componentModel).getMetadata()) : null);
    }

    protected void afterUpdate(T componentModel, WebCmsComponent mainComponent) {
    }

    @Autowired
    void setComponentRepository(WebCmsComponentRepository componentRepository) {
        this.componentRepository = componentRepository;
    }

    @Autowired
    void setDataObjectMapper(WebCmsDataObjectMapper dataObjectMapper) {
        this.dataObjectMapper = dataObjectMapper;
    }
}

