/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.modules.hibernate.business.EntityWithDto;
import com.foreach.across.modules.hibernate.util.DtoUtils;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import java.util.Objects;
import javax.validation.Valid;
import lombok.NonNull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class WebCmsComponentModel
implements ViewElement,
WebCmsObject,
WebCmsDomainBound {
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String TEMPLATE_ATTRIBUTE = "template";
    public static final String METADATA_CLASS_ATTRIBUTE = "metadata";
    @Valid
    private WebCmsComponent component;
    private String renderTemplate;
    @Valid
    private Object metadata;

    @Deprecated
    protected WebCmsComponentModel() {
        this.component = new WebCmsComponent();
    }

    protected WebCmsComponentModel(WebCmsComponentType componentType) {
        this(WebCmsComponent.builder().componentType(componentType).build());
    }

    protected WebCmsComponentModel(WebCmsComponentModel template) {
        this.setComponent(template.getComponent().asTemplate());
        this.setMetadata(WebCmsComponentModel.cloneMetadata(template));
    }

    protected WebCmsComponentModel(WebCmsComponent component) {
        this.setComponent(component);
    }

    public String getCustomTemplate() {
        if (this.renderTemplate != null) {
            return this.renderTemplate;
        }
        WebCmsComponentType componentType = this.getComponentType();
        return componentType != null ? componentType.getAttribute(TEMPLATE_ATTRIBUTE) : null;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public <V extends U, U> V getMetadata(Class<U> metadataType) {
        return (V)metadataType.cast(this.metadata);
    }

    public void setComponent(@NonNull WebCmsComponent component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        this.component = (WebCmsComponent)component.toDto();
    }

    public WebCmsComponentType getComponentType() {
        return this.component.getComponentType();
    }

    @Override
    public String getObjectId() {
        return this.component.getObjectId();
    }

    public void setObjectId(String objectId) {
        this.component.setObjectId(objectId);
    }

    public String getOwnerObjectId() {
        return this.component.getOwnerObjectId();
    }

    public void setOwner(WebCmsObject owner) {
        this.component.setOwner(owner);
    }

    public void setOwnerObjectId(String ownerObjectId) {
        this.component.setOwnerObjectId(ownerObjectId);
    }

    public boolean hasOwner() {
        return this.component.hasOwner();
    }

    public void setTitle(String title) {
        this.component.setTitle(title);
    }

    public String getTitle() {
        return StringUtils.defaultString((String)this.component.getTitle(), (String)this.component.getName());
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String name) {
        this.component.setName(name);
    }

    public int getSortIndex() {
        return this.component.getSortIndex();
    }

    public void setSortIndex(int sortIndex) {
        this.component.setSortIndex(sortIndex);
    }

    @Override
    public WebCmsDomain getDomain() {
        return this.component.getDomain();
    }

    @Override
    public void setDomain(WebCmsDomain domain) {
        this.component.setDomain(domain);
    }

    public final String getElementType() {
        return WebCmsComponentModel.class.getSimpleName();
    }

    @Override
    public final boolean isNew() {
        return this.component.isNew();
    }

    public abstract WebCmsComponentModel asComponentTemplate();

    public abstract boolean isEmpty();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebCmsComponentModel that = (WebCmsComponentModel)o;
        return Objects.equals(this.component, that.component);
    }

    public int hashCode() {
        return Objects.hash(this.component);
    }

    public String toString() {
        return "WebCmsComponentModel{name='" + this.getName() + '\'' + ", componentType=" + this.getComponentType() + ", objectId='" + this.getObjectId() + '\'' + '}';
    }

    protected static Object cloneMetadata(WebCmsComponentModel componentModel) {
        if (componentModel.hasMetadata()) {
            Object metadata = componentModel.getMetadata();
            if (metadata instanceof EntityWithDto) {
                return ((EntityWithDto)metadata).toDto();
            }
            if (metadata instanceof Cloneable) {
                return ObjectUtils.clone((Object)metadata);
            }
            return DtoUtils.createDto((Object)metadata);
        }
        return null;
    }

    public WebCmsComponent getComponent() {
        return this.component;
    }

    public String getRenderTemplate() {
        return this.renderTemplate;
    }

    public void setRenderTemplate(String renderTemplate) {
        this.renderTemplate = renderTemplate;
    }

    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }
}

