/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelSet;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Exposed
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WebCmsComponentModelHierarchy {
    public static final String REQUEST_ATTRIBUTE = "webCmsComponents";
    public static final String GLOBAL = "global";
    public static final String DEFAULT = "default";
    public static final String DOMAIN = "domain";
    public static final String ASSET = "asset";
    public static final String CONTAINER = "container";
    private final List<ComponentsWithScope> scopedComponentSets = new ArrayList<ComponentsWithScope>();

    @Autowired
    void buildGlobalComponentModelSet(WebCmsComponentModelService webCmsComponentModelService, WebCmsMultiDomainService multiDomainService) {
        this.registerComponentsForScope(new WebCmsComponentModelSet(null, WebCmsDomain.NONE, (owner, componentName) -> webCmsComponentModelService.getComponentModelByNameAndDomain((String)componentName, (WebCmsObject)owner, WebCmsDomain.NONE)), GLOBAL);
        WebCmsDomain currentDomain = multiDomainService.getCurrentDomainForType(WebCmsComponent.class);
        if (currentDomain != WebCmsDomain.NONE) {
            this.registerComponentsForScope(new WebCmsComponentModelSet(null, currentDomain, (owner, componentName) -> webCmsComponentModelService.getComponentModelByNameAndDomain((String)componentName, (WebCmsObject)owner, currentDomain)), DOMAIN);
        } else {
            this.registerAliasForScope(DOMAIN, GLOBAL);
        }
    }

    @Autowired
    void registerAsRequestAttribute(HttpServletRequest request) {
        request.setAttribute(REQUEST_ATTRIBUTE, (Object)this);
    }

    public void registerComponentsForScope(WebCmsComponentModelSet componentModelSet, String scopeName) {
        Assert.notNull((Object)componentModelSet, (String)"A valid component model set is required.");
        Assert.notNull((Object)scopeName, (String)"A scope name is required to add a set to a hierarchy.");
        ComponentsWithScope current = this.getForScope(scopeName);
        if (current != null) {
            if (scopeName.equals(current.getScopeName())) {
                current.components = componentModelSet;
            } else {
                current.removeAlias(scopeName);
                this.scopedComponentSets.add(this.scopedComponentSets.indexOf(current) + 1, new ComponentsWithScope(scopeName, componentModelSet));
            }
        } else {
            this.scopedComponentSets.add(new ComponentsWithScope(scopeName, componentModelSet));
        }
    }

    public boolean removeComponents(String scopeName) {
        return Optional.ofNullable(this.getForScope(scopeName)).map(scope -> {
            if (scopeName.equals(((ComponentsWithScope)scope).scopeName)) {
                return this.scopedComponentSets.remove(scope);
            }
            return scope.removeAlias(scopeName);
        }).orElse(false);
    }

    public boolean removeComponents(WebCmsComponentModelSet componentModelSet) {
        return this.scopedComponentSets.stream().filter(componentsWithScope -> ((ComponentsWithScope)componentsWithScope).components.equals(componentModelSet)).findFirst().map(this.scopedComponentSets::remove).orElse(false);
    }

    public WebCmsComponentModelSet getComponentsForScope(String scopeName) {
        Assert.notNull((Object)scopeName, (String)"scope name is required");
        ComponentsWithScope entry = this.getForScope(scopeName);
        return entry != null ? entry.components : null;
    }

    public void setScopeOrder(String ... scopeNames) {
        List nonAliases = Stream.of(scopeNames).map(this::getForScope).map(ComponentsWithScope::getScopeName).collect(Collectors.toList());
        this.scopedComponentSets.sort(Comparator.comparingInt(entry -> nonAliases.indexOf(((ComponentsWithScope)entry).scopeName)));
    }

    public Collection<String> getScopeNames() {
        return this.scopedComponentSets.stream().map(ComponentsWithScope::getScopeName).collect(Collectors.toList());
    }

    public String getDefaultScope() {
        return this.scopedComponentSets.isEmpty() ? null : this.scopedComponentSets.get(this.scopedComponentSets.size() - 1).scopeName;
    }

    public WebCmsComponentModel get(String componentName) {
        return this.get(componentName, true);
    }

    public WebCmsComponentModel get(String componentName, boolean searchParentScopes) {
        WebCmsComponentModel component = null;
        for (int i = this.scopedComponentSets.size() - 1; i >= 0 && component == null; --i) {
            component = this.scopedComponentSets.get(i).components.get(componentName);
            if (!searchParentScopes) break;
        }
        return component;
    }

    public WebCmsComponentModel getFromScope(String componentName, String scopeName) {
        return this.getFromScope(componentName, scopeName, false);
    }

    public WebCmsComponentModel getFromScope(String componentName, String scopeName, boolean searchParentScopes) {
        Assert.notNull((Object)scopeName, (String)"scope name is required");
        WebCmsComponentModel component = null;
        boolean scopeFound = false;
        String actualScope = DEFAULT.equals(scopeName) ? this.getDefaultScope() : scopeName;
        for (int i = this.scopedComponentSets.size() - 1; i >= 0 && component == null; --i) {
            ComponentsWithScope componentsWithScope = this.scopedComponentSets.get(i);
            if (!scopeFound && !componentsWithScope.isScope(actualScope)) continue;
            scopeFound = true;
            component = componentsWithScope.components.get(componentName);
            if (!searchParentScopes) break;
        }
        return component;
    }

    public void registerAliasForScope(String alias, String targetScopeName) {
        ComponentsWithScope target = this.getForScope(targetScopeName);
        Assert.notNull((Object)target, (String)("No components registered for target scope: '" + targetScopeName + "'"));
        this.removeComponents(alias);
        target.addAlias(alias);
    }

    public boolean containsScope(String scopeName) {
        return this.getForScope(scopeName) != null;
    }

    private ComponentsWithScope getForScope(String scopeName) {
        for (ComponentsWithScope entry : this.scopedComponentSets) {
            if (!entry.isScope(scopeName)) continue;
            return entry;
        }
        return null;
    }

    private static class ComponentsWithScope {
        private final String scopeName;
        private final Collection<String> aliases = new ArrayList<String>(2);
        private WebCmsComponentModelSet components;

        boolean isScope(String requested) {
            return this.scopeName.equals(requested) || this.aliases.contains(requested);
        }

        boolean removeAlias(String alias) {
            return this.aliases.remove(alias);
        }

        void addAlias(String alias) {
            this.aliases.add(alias);
        }

        public ComponentsWithScope(String scopeName, WebCmsComponentModelSet components) {
            this.scopeName = scopeName;
            this.components = components;
        }

        public String getScopeName() {
            return this.scopeName;
        }
    }
}

