/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.UnknownWebCmsComponentException;
import com.foreach.across.modules.webcms.domain.component.UnknownWebCmsComponentModelException;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentRepository;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelReader;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelSet;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelWriter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
final class WebCmsComponentModelServiceImpl
implements WebCmsComponentModelService {
    private final WebCmsComponentRepository componentRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsTypeSpecifierService typeSpecifierService;
    private Collection<WebCmsComponentModelReader> modelReaders = Collections.emptyList();
    private Collection<WebCmsComponentModelWriter> modelWriters = Collections.emptyList();

    @Override
    public WebCmsComponentType getComponentType(String componentTypeKey) {
        return this.typeSpecifierService.getTypeSpecifierByKey(componentTypeKey, WebCmsComponentType.class);
    }

    @Override
    public WebCmsComponentType getComponentType(String componentTypeKey, WebCmsDomain domain) {
        return this.typeSpecifierService.getTypeSpecifierByKey(componentTypeKey, WebCmsComponentType.class, domain);
    }

    @Override
    public <U extends WebCmsComponentModel> U createComponentModel(String componentTypeKey, Class<U> expectedType) {
        Assert.notNull((Object)componentTypeKey, (String)"componentTypeKey is required");
        return this.createComponentModel(this.getComponentType(componentTypeKey), expectedType);
    }

    @Override
    public <U extends WebCmsComponentModel> U createComponentModel(String componentTypeKey, WebCmsDomain domain, Class<U> expectedType) {
        return this.createComponentModel(this.getComponentType(componentTypeKey, domain), expectedType);
    }

    @Override
    public <U extends WebCmsComponentModel> U createComponentModel(WebCmsComponentType componentType, Class<U> expectedType) {
        Assert.notNull((Object)componentType, (String)"componentType is required");
        Assert.notNull(expectedType, (String)"expectedType is required");
        WebCmsComponent component = new WebCmsComponent();
        component.setComponentType(componentType);
        component.setDomain(this.multiDomainService.getCurrentDomainForType(WebCmsComponent.class));
        return (U)((WebCmsComponentModel)expectedType.cast(this.buildModelForComponent(component)));
    }

    @Override
    public <U extends WebCmsComponentModel> U getComponentModel(String objectId, Class<U> expectedType) {
        Assert.notNull(expectedType, (String)"expectedType is required");
        return (U)((WebCmsComponentModel)expectedType.cast(this.getComponentModel(objectId)));
    }

    @Override
    public WebCmsComponentModel getComponentModel(String objectId) {
        Assert.notNull((Object)objectId, (String)"objectId is required");
        WebCmsComponent component = this.componentRepository.findOneByObjectId(objectId).orElse(null);
        return component != null ? this.buildModelForComponent(component) : null;
    }

    @Override
    public <U extends WebCmsComponentModel> U getComponentModelByName(String componentName, WebCmsObject owner, Class<U> expectedType) {
        Assert.notNull(expectedType, (String)"expectedType is required");
        return (U)((WebCmsComponentModel)expectedType.cast(this.getComponentModelByName(componentName, owner)));
    }

    @Override
    public WebCmsComponentModel getComponentModelByName(String componentName, WebCmsObject owner) {
        return this.getComponentModelByNameAndDomain(componentName, owner, this.multiDomainService.getCurrentDomainForType(WebCmsComponent.class));
    }

    @Override
    public <U extends WebCmsComponentModel> U getComponentModelByNameAndDomain(String componentName, WebCmsObject owner, WebCmsDomain domain, Class<U> expectedType) {
        Assert.notNull(expectedType, (String)"expectedType is required");
        return (U)((WebCmsComponentModel)expectedType.cast(this.getComponentModelByNameAndDomain(componentName, owner, domain)));
    }

    @Override
    public WebCmsComponentModel getComponentModelByNameAndDomain(String componentName, WebCmsObject owner, WebCmsDomain domain) {
        Assert.notNull((Object)componentName, (String)"componentName is required");
        return this.componentRepository.findOneByOwnerObjectIdAndNameAndDomain(owner != null ? owner.getObjectId() : null, componentName, domain).map(this::buildModelForComponent).orElse(null);
    }

    @Override
    public WebCmsComponentModelSet buildComponentModelSetForOwner(WebCmsObject object, boolean eager) {
        return this.buildComponentModelSetForOwner(object, this.multiDomainService.getCurrentDomainForType(WebCmsComponent.class), eager);
    }

    @Override
    public WebCmsComponentModelSet buildComponentModelSetForOwner(WebCmsObject object, WebCmsDomain domain, boolean eager) {
        Assert.notNull((Object)object, (String)"owner is required");
        WebCmsComponentModelSet modelSet = new WebCmsComponentModelSet();
        modelSet.setOwner(object);
        modelSet.setDomain(domain);
        if (eager) {
            this.componentRepository.findAllByOwnerObjectIdAndDomainOrderBySortIndexAsc(object.getObjectId(), domain).stream().filter(c -> !StringUtils.isEmpty((CharSequence)c.getName())).forEach(component -> modelSet.add(this.buildModelForComponent((WebCmsComponent)component)));
        } else {
            modelSet.setFetcherFunction((owner, componentName) -> this.getComponentModelByNameAndDomain((String)componentName, (WebCmsObject)owner, domain));
        }
        return modelSet;
    }

    @Override
    public Collection<WebCmsComponentModel> getComponentModelsForOwner(WebCmsObject object) {
        return this.getComponentModelsForOwner(object, this.multiDomainService.getCurrentDomainForType(WebCmsComponent.class));
    }

    @Override
    public Collection<WebCmsComponentModel> getComponentModelsForOwner(WebCmsObject object, WebCmsDomain domain) {
        return this.componentRepository.findAllByOwnerObjectIdAndDomainOrderBySortIndexAsc(object.getObjectId(), domain).stream().map(this::buildModelForComponent).collect(Collectors.toList());
    }

    @Override
    public WebCmsComponentModel buildModelForComponent(WebCmsComponent component) {
        return this.buildModelForComponent(component, WebCmsComponentModel.class);
    }

    @Override
    public <U extends WebCmsComponentModel> U buildModelForComponent(WebCmsComponent component, Class<U> expectedType) {
        Assert.notNull((Object)component, (String)"component is required");
        return (U)((WebCmsComponentModel)expectedType.cast(this.modelReaders.stream().filter(r -> r.supports(component)).findFirst().orElseThrow(() -> new UnknownWebCmsComponentException(component)).readFromComponent(component)));
    }

    @Override
    @Transactional
    public WebCmsComponent save(WebCmsComponent component) {
        if (component.isNew()) {
            return this.save(this.buildModelForComponent(component));
        }
        return (WebCmsComponent)this.componentRepository.save(component);
    }

    @Override
    @Transactional
    public WebCmsComponent save(WebCmsComponentModel componentModel) {
        return this.modelWriters.stream().filter(r -> r.supports(componentModel)).findFirst().orElseThrow(() -> new UnknownWebCmsComponentModelException(componentModel)).save(componentModel);
    }

    @Autowired
    void setModelReaders(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsComponentModelReader> modelReaders) {
        this.modelReaders = modelReaders;
    }

    @Autowired
    void setModelWriters(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsComponentModelWriter> modelWriters) {
        this.modelWriters = modelWriters;
    }

    public WebCmsComponentModelServiceImpl(WebCmsComponentRepository componentRepository, WebCmsMultiDomainService multiDomainService, WebCmsTypeSpecifierService typeSpecifierService) {
        this.componentRepository = componentRepository;
        this.multiDomainService = multiDomainService;
        this.typeSpecifierService = typeSpecifierService;
    }
}

