/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model;

import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.springframework.util.Assert;

public class WebCmsComponentModelSet {
    private static final WebCmsComponentModel NOT_FOUND_MARKER = new WebCmsComponentModel(WebCmsComponent.builder().build()){

        @Override
        public WebCmsComponentModel asComponentTemplate() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    };
    private final Map<String, WebCmsComponentModel> componentsByName = new HashMap<String, WebCmsComponentModel>();
    private WebCmsObject owner;
    private WebCmsDomain domain;
    private BiFunction<WebCmsObject, String, WebCmsComponentModel> fetcherFunction;

    public void add(WebCmsComponentModel componentModel) {
        Assert.notNull((Object)componentModel, (String)"componentModel is required");
        Assert.notNull((Object)componentModel.getName(), (String)"Only component models with a name are allowed in a WebCmsComponentModelSet");
        this.put(componentModel.getName(), componentModel);
    }

    public void put(@NonNull String name, WebCmsComponentModel componentModel) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.componentsByName.put(name, componentModel != null ? componentModel : NOT_FOUND_MARKER);
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public WebCmsComponentModel get(String name) {
        WebCmsComponentModel model = this.componentsByName.get(name);
        if (model == null && this.fetcherFunction != null) {
            model = this.fetcherFunction.apply(this.owner, name);
            this.componentsByName.put(name, model != null ? model : NOT_FOUND_MARKER);
        }
        return model != NOT_FOUND_MARKER ? model : null;
    }

    public WebCmsComponentModel remove(String name) {
        WebCmsComponentModel existing = this.get(name);
        if (existing != null) {
            this.remove(existing);
        }
        return existing;
    }

    public boolean remove(@NonNull WebCmsComponentModel componentModel) {
        if (componentModel == null) {
            throw new NullPointerException("componentModel is marked non-null but is null");
        }
        ArrayList namesToRemove = new ArrayList();
        this.componentsByName.forEach((key, value) -> {
            if (componentModel.equals(value)) {
                namesToRemove.add(key);
            }
        });
        namesToRemove.forEach(this.componentsByName::remove);
        return !namesToRemove.isEmpty();
    }

    public void clear() {
        this.componentsByName.clear();
    }

    public WebCmsComponentModelSet() {
    }

    public WebCmsComponentModelSet(WebCmsObject owner, WebCmsDomain domain, BiFunction<WebCmsObject, String, WebCmsComponentModel> fetcherFunction) {
        this.owner = owner;
        this.domain = domain;
        this.fetcherFunction = fetcherFunction;
    }

    public WebCmsObject getOwner() {
        return this.owner;
    }

    public void setOwner(WebCmsObject owner) {
        this.owner = owner;
    }

    public WebCmsDomain getDomain() {
        return this.domain;
    }

    public void setDomain(WebCmsDomain domain) {
        this.domain = domain;
    }

    public void setFetcherFunction(BiFunction<WebCmsObject, String, WebCmsComponentModel> fetcherFunction) {
        this.fetcherFunction = fetcherFunction;
    }
}

