/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model.create;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelHierarchy;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelSet;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateService;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
@Exposed
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WebCmsComponentAutoCreateQueue {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsComponentAutoCreateQueue.class);
    public static final String CONTAINER_MEMBER_SCOPE = "container";
    private final Map<String, WebCmsComponentModel> componentsCreated = new HashMap<String, WebCmsComponentModel>();
    private final Map<String, WebCmsComponentAutoCreateTask> tasksByKey = new HashMap<String, WebCmsComponentAutoCreateTask>();
    private final ArrayDeque<WebCmsComponentAutoCreateTask> tasks = new ArrayDeque();
    private final ArrayDeque<WebCmsComponentAutoCreateTask> outputQueue = new ArrayDeque();
    private final WebCmsComponentModelHierarchy componentModelHierarchy;
    private final WebCmsComponentAutoCreateService autoCreateService;

    public WebCmsComponentAutoCreateTask schedule(String componentName, String scope, String type) {
        String key = CONTAINER_MEMBER_SCOPE.equals(scope) ? UUID.randomUUID().toString() : componentName + ":" + scope;
        WebCmsComponentAutoCreateTask creationTask = this.tasksByKey.computeIfAbsent(key, k -> {
            WebCmsComponentType componentType = this.autoCreateService.resolveComponentType(type);
            return new WebCmsComponentAutoCreateTask(componentName, scope, componentType);
        });
        this.tasks.add(creationTask);
        return creationTask;
    }

    public WebCmsComponentAutoCreateTask getCurrentTask() {
        return this.outputQueue.peek();
    }

    public WebCmsComponentAutoCreateTask getTask(String taskId) {
        return this.tasksByKey.values().stream().filter(t -> taskId.equals(t.getTaskId())).findFirst().orElse(null);
    }

    public void outputStarted(String taskId) {
        WebCmsComponentAutoCreateTask current;
        while ((current = this.tasks.remove()) != null && !taskId.equals(current.getTaskId())) {
        }
        this.outputQueue.push(current);
    }

    public void outputFinished(String taskId, String output) {
        if (!this.componentsCreated.containsKey(taskId)) {
            WebCmsComponentAutoCreateTask current = this.outputQueue.pop();
            Assert.isTrue((boolean)taskId.equals(current.getTaskId()), (String)"Auto create component flow corrupt - task id did not match expected task id");
            current.setOutput(output);
            WebCmsComponentAutoCreateTask next = this.outputQueue.peek();
            if (next != null && CONTAINER_MEMBER_SCOPE.equals(current.getScopeName())) {
                next.addChild(current);
            } else {
                WebCmsComponentModelSet componentModelSet = this.componentModelHierarchy.getComponentsForScope(current.getScopeName());
                if (componentModelSet != null) {
                    current.setOwner(componentModelSet.getOwner());
                    current.setDomain(componentModelSet.getDomain());
                    WebCmsComponentModel componentModel = this.autoCreateService.createComponent(current);
                    componentModelSet.add(componentModel);
                    this.componentsCreated.put(current.getTaskId(), componentModel);
                } else {
                    LOG.error("Unable to auto-create component model - scope {} is not registered!", (Object)current.getScopeName());
                }
            }
        }
    }

    public void placeholderRendered(String placeholderName) {
        WebCmsComponentAutoCreateTask current = this.getCurrentTask();
        if (current != null) {
            current.addChild(new WebCmsComponentAutoCreateTask(placeholderName, null, this.autoCreateService.resolveComponentType("placeholder")));
        }
    }

    public void createProxy(String objectId) {
        WebCmsComponentAutoCreateTask current = this.getCurrentTask();
        if (current != null) {
            current.addChild(new WebCmsComponentAutoCreateTask(objectId, CONTAINER_MEMBER_SCOPE, this.autoCreateService.resolveComponentType("proxy")));
        }
    }

    public WebCmsComponentModel getComponentCreated(String taskId) {
        WebCmsComponentModel componentModel = this.componentsCreated.get(taskId);
        if (componentModel == null) {
            LOG.error("Could not retrieve the expected auto-created component with task id {}", (Object)taskId);
        }
        return componentModel;
    }

    public WebCmsComponentAutoCreateQueue(WebCmsComponentModelHierarchy componentModelHierarchy, WebCmsComponentAutoCreateService autoCreateService) {
        this.componentModelHierarchy = componentModelHierarchy;
        this.autoCreateService = autoCreateService;
    }
}

