/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model.create;

import com.foreach.across.core.annotations.RefreshableCollection;
import com.foreach.across.core.development.AcrossDevelopmentMode;
import com.foreach.across.modules.entity.util.EntityUtils;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateStrategy;
import com.foreach.across.modules.webcms.domain.component.model.create.WebCmsComponentAutoCreateTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebCmsComponentAutoCreateService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsComponentAutoCreateService.class);
    private final AcrossDevelopmentMode developmentMode;
    private final WebCmsComponentModelService componentModelService;
    private final WebCmsDataConversionService dataConversionService;
    private Collection<WebCmsComponentAutoCreateStrategy> createStrategies = Collections.emptyList();
    private String defaultComponentType = "html";

    public WebCmsComponentType resolveComponentType(String componentTypeName) {
        String nameToResolve = StringUtils.isEmpty((CharSequence)componentTypeName) ? this.defaultComponentType : componentTypeName;
        return Optional.ofNullable(this.componentModelService.getComponentType(nameToResolve)).orElseThrow(() -> new IllegalArgumentException("Unknown component type: " + componentTypeName));
    }

    @Transactional
    public synchronized WebCmsComponentModel createComponent(WebCmsComponentAutoCreateTask task) {
        WebCmsComponentModel componentModel = this.buildComponent(task);
        if (componentModel != null && componentModel.isNew()) {
            WebCmsComponentModel existing = this.componentModelService.getComponentModelByNameAndDomain(componentModel.getName(), task.getOwner(), task.getDomain());
            if (existing == null) {
                this.componentModelService.save(componentModel);
            } else {
                LOG.warn("Skipping auto-creation of component, component with name {} already exists for owner {}", (Object)task.getComponentName(), (Object)task.getOwner());
                componentModel = existing;
            }
        }
        return componentModel;
    }

    public WebCmsComponentModel buildComponent(WebCmsComponentAutoCreateTask task) {
        WebCmsComponentType componentType = task.getComponentType();
        if (componentType != null) {
            try {
                WebCmsComponentModel component = this.componentModelService.createComponentModel(componentType, WebCmsComponentModel.class);
                component.setDomain(task.getDomain());
                component.setName(task.getComponentName());
                component.setTitle(EntityUtils.generateDisplayName((String)task.getComponentName()));
                component.setOwner(task.getOwner());
                this.createStrategies.stream().filter(strategy -> strategy.supports(component, task)).findFirst().orElseThrow(() -> new IllegalStateException("No valid auto-create strategy for " + componentType)).buildComponentModel(this, component, task);
                this.applyAttributeValues(component, task.getAttributeValues());
                return component;
            }
            catch (Exception e) {
                LOG.error("Unable to auto-create component, exception occurred", (Throwable)e);
                if (this.developmentMode.isActive()) {
                    throw new WebCmsComponentAutoCreateException("Unable to auto-create component " + task.getComponentName(), e);
                }
            }
        } else {
            LOG.error("Unable to auto-create component, unknown component type: {}", (Object)task.getComponentType());
        }
        return null;
    }

    private void applyAttributeValues(WebCmsComponentModel componentModel, List<WebCmsComponentAutoCreateTask.AttributeValue> attributeValues) {
        BeanWrapperImpl component = new BeanWrapperImpl((Object)componentModel);
        BeanWrapperImpl metadata = componentModel.hasMetadata() ? new BeanWrapperImpl(componentModel.getMetadata()) : null;
        for (WebCmsComponentAutoCreateTask.AttributeValue attributeValue : attributeValues) {
            TypeDescriptor typeDescriptor;
            WebCmsComponentAutoCreateTask.Attribute attributeType = attributeValue.getAttribute();
            if (attributeType == WebCmsComponentAutoCreateTask.Attribute.ANY || attributeType == WebCmsComponentAutoCreateTask.Attribute.PROPERTY) {
                typeDescriptor = component.getPropertyTypeDescriptor(attributeValue.getKey());
                if (typeDescriptor != null) {
                    this.applyPropertyValue((BeanWrapper)component, attributeValue.getKey(), attributeValue.getValue(), typeDescriptor);
                } else if (attributeType == WebCmsComponentAutoCreateTask.Attribute.ANY) {
                    attributeType = WebCmsComponentAutoCreateTask.Attribute.METADATA;
                } else {
                    LOG.warn("Ignoring property value for component {}: {}", (Object)componentModel.getName(), (Object)attributeValue);
                    if (this.developmentMode.isActive()) {
                        throw new WebCmsComponentAutoCreateException("Not a valid property for component " + componentModel.getName() + ": " + attributeValue);
                    }
                }
            }
            if (attributeType != WebCmsComponentAutoCreateTask.Attribute.METADATA) continue;
            TypeDescriptor typeDescriptor2 = typeDescriptor = metadata != null ? metadata.getPropertyTypeDescriptor(attributeValue.getKey()) : null;
            if (typeDescriptor != null) {
                this.applyPropertyValue((BeanWrapper)metadata, attributeValue.getKey(), attributeValue.getValue(), typeDescriptor);
                continue;
            }
            LOG.warn("Ignoring property value for component metadata {}: {}", (Object)componentModel.getName(), (Object)attributeValue);
            if (!this.developmentMode.isActive()) continue;
            throw new WebCmsComponentAutoCreateException("Not a valid metadata property for component " + componentModel.getName() + ": " + attributeValue);
        }
    }

    private void applyPropertyValue(BeanWrapper target, String propertyName, Object propertyValue, TypeDescriptor typeDescriptor) {
        block6: {
            try {
                TypeDescriptor sourceType = TypeDescriptor.forObject((Object)propertyValue);
                if (propertyValue instanceof Map && !this.dataConversionService.canConvert(sourceType, typeDescriptor)) {
                    Object currentPropertyValue = target.getPropertyValue(propertyName);
                    if (currentPropertyValue == null) {
                        throw new RuntimeException("Unable to converted nested object - value is null for property " + propertyName);
                    }
                    this.dataConversionService.convertToPropertyValues((Map)propertyValue, target);
                } else {
                    Object valueToSet = this.dataConversionService.convert(propertyValue, sourceType, typeDescriptor);
                    if (propertyValue != null && valueToSet == null) {
                        throw new IllegalArgumentException("Illegal converted value for '" + propertyName + "': " + sourceType.getName() + " to " + typeDescriptor.getName() + " resulted in null for '" + propertyValue + "'");
                    }
                    target.setPropertyValue(propertyName, valueToSet);
                }
            }
            catch (Exception e) {
                LOG.error("Unable to set property value on component", (Throwable)e);
                if (!this.developmentMode.isActive()) break block6;
                throw new WebCmsComponentAutoCreateException("Unable to set component property value for " + propertyName + ": " + propertyValue, e);
            }
        }
    }

    @Autowired
    void setCreateStrategies(@RefreshableCollection(includeModuleInternals=true, incremental=true) Collection<WebCmsComponentAutoCreateStrategy> createStrategies) {
        this.createStrategies = createStrategies;
    }

    public WebCmsComponentAutoCreateService(AcrossDevelopmentMode developmentMode, WebCmsComponentModelService componentModelService, WebCmsDataConversionService dataConversionService) {
        this.developmentMode = developmentMode;
        this.componentModelService = componentModelService;
        this.dataConversionService = dataConversionService;
    }

    public void setDefaultComponentType(String defaultComponentType) {
        this.defaultComponentType = defaultComponentType;
    }

    static class WebCmsComponentAutoCreateException
    extends RuntimeException {
        public WebCmsComponentAutoCreateException(String message) {
            super(message);
        }

        public WebCmsComponentAutoCreateException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

