/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.model.create;

import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponentType;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class WebCmsComponentAutoCreateTask {
    private final String taskId = UUID.randomUUID().toString();
    private final String componentName;
    private final String scopeName;
    private final WebCmsComponentType componentType;
    private final Deque<WebCmsComponentAutoCreateTask> children = new ArrayDeque<WebCmsComponentAutoCreateTask>();
    private final Map<String, Object> metadata = new LinkedHashMap<String, Object>();
    private final List<AttributeValue> attributeValues = new ArrayList<AttributeValue>();
    private int sortIndex;
    private WebCmsObject owner;
    private WebCmsDomain domain;
    private String output;

    public void addChild(WebCmsComponentAutoCreateTask task) {
        task.sortIndex = this.children.size() + 1;
        this.children.add(task);
    }

    public void addAttributeValue(Attribute attributeType, String key, Object value) {
        this.attributeValues.add(new AttributeValue(attributeType, key, value));
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public WebCmsComponentType getComponentType() {
        return this.componentType;
    }

    public Deque<WebCmsComponentAutoCreateTask> getChildren() {
        return this.children;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public WebCmsObject getOwner() {
        return this.owner;
    }

    public WebCmsDomain getDomain() {
        return this.domain;
    }

    public String getOutput() {
        return this.output;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setOwner(WebCmsObject owner) {
        this.owner = owner;
    }

    public void setDomain(WebCmsDomain domain) {
        this.domain = domain;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public WebCmsComponentAutoCreateTask(String componentName, String scopeName, WebCmsComponentType componentType) {
        this.componentName = componentName;
        this.scopeName = scopeName;
        this.componentType = componentType;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<AttributeValue> getAttributeValues() {
        return this.attributeValues;
    }

    static class AttributeValue {
        private final Attribute attribute;
        private final String key;
        private final Object value;

        public Attribute getAttribute() {
            return this.attribute;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public AttributeValue(Attribute attribute, String key, Object value) {
            this.attribute = attribute;
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "WebCmsComponentAutoCreateTask.AttributeValue(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }

    public static enum Attribute {
        ANY,
        METADATA,
        PROPERTY;

    }
}

