/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.component.placeholder;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.webcms.domain.component.placeholder.WebCmsPlaceholderLookupService;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;

@Component
@Exposed
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class WebCmsPlaceholderContentModel
implements WebCmsPlaceholderLookupService {
    private static final Object NULL = new Object();
    private Map<String, Object> currentData = new HashMap<String, Object>();
    private final Deque<Map<String, Object>> allData = new ArrayDeque<Map<String, Object>>();

    public WebCmsPlaceholderContentModel() {
        this.increaseLevel();
    }

    public void setPlaceholderContent(@NonNull String placeholderName, Object content) {
        if (placeholderName == null) {
            throw new NullPointerException("placeholderName is marked non-null but is null");
        }
        this.currentData.put(placeholderName, content != null ? content : NULL);
    }

    @Override
    public Optional<Object> getPlaceholderContent(String placeholderName) {
        return this.allData.stream().map(m -> m.get(placeholderName)).filter(Objects::nonNull).findFirst().map(v -> v == NULL ? null : v);
    }

    public void increaseLevel() {
        this.currentData = new HashMap<String, Object>();
        this.allData.addFirst(this.currentData);
    }

    public void decreaseLevel() {
        this.allData.removeFirst();
        if (this.allData.isEmpty()) {
            this.increaseLevel();
        }
    }
}

